/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import xyz.pixelatedw.mineminenomi.abilities.TakedownKickAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;

public class TakedownKickWrapperGoal
extends AbilityWrapperGoal<MobEntity, TakedownKickAbility> {
    private LivingEntity target;
    private double groundDistance = 5.0;
    private double minDistance = 10.0;
    private double maxDistance = 20.0;

    public TakedownKickWrapperGoal(MobEntity entity) {
        super(entity, TakedownKickAbility.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (!GoalUtil.canMove((LivingEntity)this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (!GoalUtil.canSee(this.entity, this.target)) {
            return false;
        }
        if (DevilFruitHelper.getDifferenceToFloor((Entity)this.entity) > this.groundDistance) {
            return false;
        }
        if (DevilFruitHelper.getDifferenceToFloor((Entity)this.target) < this.minDistance) {
            return false;
        }
        if (GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.minDistance)) {
            return false;
        }
        return !GoalUtil.isOutsideDistance((LivingEntity)this.entity, this.target, this.maxDistance);
    }

    @Override
    public boolean canContinueToUseWrapper() {
        return true;
    }

    @Override
    public void startWrapper() {
        ((TakedownKickAbility)this.getAbility()).setTarget((Entity)this.target);
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void tickWrapper() {
    }

    @Override
    public void stopWrapper() {
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }
}

