/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import xyz.pixelatedw.mineminenomi.abilities.doru.DoruDoruBallAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;

public class DoruDoruBallWrapperGoal
extends AbilityWrapperGoal<MobEntity, DoruDoruBallAbility> {
    private LivingEntity target;
    private double distance = 5.0;
    private int triggerHits = 5;
    private int hits;
    private float previousHealth;

    public DoruDoruBallWrapperGoal(MobEntity entity) {
        super(entity, DoruDoruBallAbility.INSTANCE);
    }

    public DoruDoruBallWrapperGoal setMinTriggerHits(int hits) {
        this.triggerHits = hits;
        return this;
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (!GoalUtil.canSee(this.entity, this.target)) {
            return false;
        }
        if (this.previousHealth == 0.0f) {
            this.previousHealth = this.entity.func_110143_aJ();
        } else {
            if (this.entity.func_110143_aJ() >= this.entity.func_110138_aP()) {
                return false;
            }
            if (this.entity.func_110143_aJ() < this.previousHealth) {
                ++this.hits;
                this.previousHealth = this.entity.func_110143_aJ();
            } else if (this.entity.func_110143_aJ() > this.previousHealth) {
                this.previousHealth = this.entity.func_110143_aJ();
            }
        }
        if (this.hits < this.triggerHits) {
            return false;
        }
        return !GoalUtil.isOutsideDistance((LivingEntity)this.entity, this.target, this.distance);
    }

    @Override
    public boolean canContinueToUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        return !GoalUtil.isOutsideDistance((LivingEntity)this.entity, this.target, this.distance);
    }

    @Override
    public void startWrapper() {
    }

    @Override
    public void tickWrapper() {
    }

    @Override
    public void stopWrapper() {
        this.hits = 0;
    }
}

