/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.SharkOnToothAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;

public class SharkOnToothWrapperGoal
extends AbilityWrapperGoal<MobEntity, SharkOnToothAbility> {
    public static final double DEFAULT_MAX_DISTANCE = 10.0;
    private LivingEntity target;
    private double groundDistance = 5.0;
    private double minDistance = 3.0;
    private double maxDistance = 10.0;

    public SharkOnToothWrapperGoal(MobEntity entity) {
        super(entity, SharkOnToothAbility.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.minDistance)) {
            return false;
        }
        if (GoalUtil.isOutsideDistance((LivingEntity)this.entity, this.target, this.maxDistance)) {
            return false;
        }
        return !(DevilFruitHelper.getDifferenceToFloor((Entity)this.entity) > this.groundDistance);
    }

    @Override
    public boolean canContinueToUseWrapper() {
        if (GoalUtil.isOutsideDistance((LivingEntity)this.entity, this.target, this.maxDistance)) {
            return false;
        }
        if (DevilFruitHelper.getDifferenceToFloor((Entity)this.entity) > this.groundDistance) {
            return false;
        }
        return ((SharkOnToothAbility)this.getAbility()).isContinuous();
    }

    @Override
    public void startWrapper() {
        this.entity.func_70661_as().func_75499_g();
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void tickWrapper() {
        this.entity.func_70661_as().func_75499_g();
    }

    @Override
    public void stopWrapper() {
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }
}

