/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.kilo;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.abilities.kilo.KiloPress1Ability;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class KiloPress1WrapperGoal
extends AbilityWrapperGoal<MobEntity, KiloPress1Ability> {
    private LivingEntity target;
    private Interval jumpInterval = Interval.startAtMax(50);
    private int floatTime;
    private double floatSpeed = 0.2;
    private boolean forceUse;

    public KiloPress1WrapperGoal(MobEntity entity) {
        super(entity, KiloPress1Ability.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        if (this.forceUse) {
            return true;
        }
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        return this.entity.func_233570_aj_();
    }

    @Override
    public boolean canContinueToUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        return this.hasUmbrellaInHand();
    }

    public boolean hasUmbrellaInHand() {
        ItemStack itemStack = this.entity.func_184582_a(EquipmentSlotType.MAINHAND);
        return !itemStack.func_190926_b() && itemStack.func_77973_b().equals(ModWeapons.UMBRELLA.get());
    }

    @Override
    public void startWrapper() {
        this.forceUse = false;
        this.floatSpeed = this.entity.func_110148_a(Attributes.field_233821_d_).func_111126_e();
    }

    @Override
    public void tickWrapper() {
        if (this.entity.func_233570_aj_() && this.jumpInterval.canTick()) {
            this.entity.func_70683_ar().func_75660_a();
        } else if (!this.entity.func_233570_aj_()) {
            ++this.floatTime;
            GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
            if (this.floatTime > 50) {
                Vector3d dist = this.entity.func_213303_ch().func_178788_d(this.entity.func_70638_az().func_213303_ch()).func_72432_b();
                AbilityHelper.setDeltaMovement((Entity)this.entity, (this.entity.func_213322_ci().field_72450_a - dist.field_72450_a) * this.floatSpeed, this.entity.func_213322_ci().field_72448_b, (this.entity.func_213322_ci().field_72449_c - dist.field_72449_c) * this.floatSpeed);
            }
        }
    }

    @Override
    public void stopWrapper() {
        this.floatTime = 0;
    }

    public boolean isForced() {
        return this.forceUse;
    }

    public void forceUse() {
        this.forceUse = true;
    }
}

