/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.GeppoAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class GeppoWrapperGoal
extends AbilityWrapperGoal<MobEntity, GeppoAbility> {
    private LivingEntity target;
    private Vector3d targetVec;

    public GeppoWrapperGoal(MobEntity entity) {
        super(entity, GeppoAbility.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (!GoalUtil.canMove((LivingEntity)this.entity)) {
            return false;
        }
        if (!this.entity.field_70170_p.func_226660_f_(this.entity.func_233580_cy_())) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        this.targetVec = null;
        boolean needsHeight = false;
        boolean canSeeTarget = GoalUtil.canSee(this.entity, this.target);
        double yDistance = 0.0;
        if (canSeeTarget) {
            yDistance = this.target.func_213303_ch().func_178788_d((Vector3d)this.entity.func_213303_ch()).field_72448_b;
        } else {
            double followDistance = this.entity.func_233637_b_(Attributes.field_233819_b_);
            for (int i = 5; i < 30; i += 5) {
                boolean isVisibleOnYAxis;
                Vector3d lookOffset = this.entity.func_213303_ch().func_72441_c(0.0, (double)i, 0.0);
                boolean bl = isVisibleOnYAxis = GoalUtil.isVisibleFrom((LivingEntity)this.entity, (Entity)this.target, lookOffset) && GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, followDistance);
                if (!isVisibleOnYAxis) continue;
                yDistance = lookOffset.func_178788_d((Vector3d)this.entity.func_213303_ch()).field_72448_b;
                break;
            }
        }
        if (yDistance != 0.0) {
            if (this.entity.func_233570_aj_() && yDistance >= 5.0) {
                needsHeight = true;
            } else if (!this.entity.func_233570_aj_() && !canSeeTarget && yDistance > -10.0 && this.getCurrentStacks() != this.getDefaultStacks()) {
                needsHeight = true;
            }
        }
        if (needsHeight) {
            this.targetVec = this.entity.func_213303_ch().func_72441_c(0.0, 5.0, 0.0);
            return true;
        }
        if (canSeeTarget && !this.entity.func_233570_aj_()) {
            if (GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, 10.0)) {
                return false;
            }
            double targetYPos = this.target.func_226278_cu_();
            double difference = Math.abs(DevilFruitHelper.getFloorLevel((Entity)this.entity).field_72448_b - targetYPos);
            if (difference < 5.0) {
                return false;
            }
            this.targetVec = this.target.func_213303_ch();
            return true;
        }
        return false;
    }

    @Override
    public boolean canContinueToUseWrapper() {
        return false;
    }

    @Override
    public void startWrapper() {
        if (this.targetVec != null) {
            GoalUtil.lookAt(this.entity, this.targetVec);
        }
    }

    @Override
    public void tickWrapper() {
    }

    @Override
    public void stopWrapper() {
    }

    public int getCurrentStacks() {
        return ((GeppoAbility)this.getAbility()).getComponent(ModAbilityKeys.STACK).map(comp -> comp.getStacks()).orElse(0);
    }

    public int getDefaultStacks() {
        return ((GeppoAbility)this.getAbility()).getComponent(ModAbilityKeys.STACK).map(comp -> comp.getDefaultStacks()).orElse(0);
    }
}

