/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.commands;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.ITamableEntity;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GuardCommandGoal<E extends MobEntity>
extends TickedGoal<E> {
    private final Predicate<LivingEntity> entityPredicate;
    private final TargetsPredicate targetPredicate;
    private Vector3d guardPosition;
    private long lastManualStart;

    public GuardCommandGoal(E entity) {
        super(entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
        this.entityPredicate = target -> {
            LivingEntity owner;
            if (entity instanceof ITamableEntity && (owner = ((ITamableEntity)entity).getOwner()) != null && owner.equals(target)) {
                return false;
            }
            return ((ICommandReceiver)entity).getLastCommandSender() == null || !((ICommandReceiver)entity).getLastCommandSender().equals(target);
        };
        this.targetPredicate = new TargetsPredicate().testEnemyFaction().testSimpleInView().selector(this.entityPredicate);
    }

    public boolean func_75250_a() {
        if (!((ICommandReceiver)this.entity).getCurrentCommand().equals((Object)NPCCommand.GUARD)) {
            return false;
        }
        return this.hasTimePassedSinceLastEnd(WyHelper.secondsToTicks(5.0f));
    }

    public boolean func_75253_b() {
        if (!((ICommandReceiver)this.entity).getCurrentCommand().equals((Object)NPCCommand.GUARD)) {
            return false;
        }
        return this.entity.func_70638_az() == null || !this.entity.func_70638_az().func_70089_S();
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.entity.func_70624_b(null);
        this.entity.func_70604_c(null);
        this.entity.func_70661_as().func_75499_g();
        if (this.guardPosition == null || this.lastManualStart != ((ICommandReceiver)this.entity).getLastCommandTime()) {
            this.guardPosition = this.entity.func_213303_ch();
        }
        this.lastManualStart = ((ICommandReceiver)this.entity).getLastCommandTime();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.getTickCount() % 20L != 0L) {
            return;
        }
        if (this.entity.func_213303_ch().func_72438_d(this.guardPosition) > 6.0) {
            this.entity.func_70661_as().func_75492_a(this.guardPosition.field_72450_a, this.guardPosition.field_72448_b, this.guardPosition.field_72449_c, 1.25);
        }
        LivingEntity possibleTarget = TargetHelper.getEntitiesInArea((LivingEntity)this.entity, 10.0, this.targetPredicate, LivingEntity.class).stream().sorted(TargetHelper.closestComparator(this.guardPosition)).findFirst().orElse(null);
        this.entity.func_70624_b(possibleTarget);
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
    }
}

