/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.donkrieg;

import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.abilities.MH5Ability;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.DonKriegEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class DonKriegPhaseSwitcherGoal
extends TickedGoal<DonKriegEntity> {
    private static final float DAISENSO_HP_THRESHOLD = 70.0f;
    private final IAbilityData abilityData;
    private final float mh5HPThreshold;

    public DonKriegPhaseSwitcherGoal(DonKriegEntity entity) {
        super(entity);
        this.abilityData = AbilityDataCapability.get((LivingEntity)entity);
        this.mh5HPThreshold = entity.isDifficultyHardOrAbove() ? 70.0f : 50.0f;
    }

    public boolean func_75250_a() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (!GoalUtil.canSee(this.entity, ((DonKriegEntity)this.entity).func_70638_az())) {
            return false;
        }
        if ((((DonKriegEntity)this.entity).hasFistPhaseActive() || ((DonKriegEntity)this.entity).hasMH5PhaseActive()) && this.trySwitchToDaisensoPhase()) {
            ((DonKriegEntity)this.entity).startDaisensoPhase();
            return true;
        }
        if ((((DonKriegEntity)this.entity).hasFistPhaseActive() || ((DonKriegEntity)this.entity).hasDaisensoPhaseActive()) && this.trySwitchToMH5Phase()) {
            ((DonKriegEntity)this.entity).startMH5Phase();
            return true;
        }
        return false;
    }

    private boolean trySwitchToDaisensoPhase() {
        if (((DonKriegEntity)this.entity).hasMH5PhaseActive()) {
            MH5Ability mh5Ability = this.abilityData.getEquippedAbility(MH5Ability.INSTANCE);
            if (mh5Ability != null) {
                boolean isCharging = mh5Ability.getComponent(ModAbilityKeys.CHARGE).map(comp -> comp.isCharging()).orElse(false);
                if (isCharging) {
                    return false;
                }
                boolean isOnCooldown = mh5Ability.getComponent(ModAbilityKeys.COOLDOWN).map(comp -> comp.isOnCooldown()).orElse(false);
                return isOnCooldown;
            }
        } else if (GoalUtil.hasHealthAbovePercentage((LivingEntity)this.entity, 70.0)) {
            return false;
        }
        return true;
    }

    private boolean trySwitchToMH5Phase() {
        boolean isOnCooldown;
        if (GoalUtil.hasHealthAbovePercentage((LivingEntity)this.entity, this.mh5HPThreshold)) {
            return false;
        }
        MH5Ability mh5Ability = this.abilityData.getEquippedAbility(MH5Ability.INSTANCE);
        return mh5Ability == null || !(isOnCooldown = mh5Ability.getComponent(ModAbilityKeys.COOLDOWN).map(comp -> comp.isOnCooldown()).orElse(false).booleanValue());
    }

    public boolean func_75253_b() {
        return false;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
    }
}

