/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.BellyFlopAbility;
import xyz.pixelatedw.mineminenomi.abilities.SlamAbility;
import xyz.pixelatedw.mineminenomi.abilities.WeaponSpinAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ClimbOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.BattoStrikeWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.BellyFlopWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.SlamWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.WeaponSpinWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiImbuingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.GeppoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sube.SubeSubeDeflectWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sube.SubeSubeSpurWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.DyeableModSwordItem;

public class AlvidaEntity
extends OPBossEntity<AlvidaEntity> {
    private static final AbilityPool2 ALVIDA = new AbilityPool2().addFlag("ignoreCooldown", true);
    private NPCPhase<AlvidaEntity> standardPhase = new SimplePhase<AlvidaEntity>("Standard Phase", this);
    private NPCPhase<AlvidaEntity> slidePhase = new SimplePhase<AlvidaEntity>("Slide Phase", this);

    public AlvidaEntity(EntityType type, World world) {
        super(type, world);
    }

    public AlvidaEntity(EntityType type, InProgressChallenge challenge) {
        super(type, challenge);
    }

    @Override
    public void initBoss() {
        ItemStack plumeHeadStack = ((Item)ModArmors.PLUME_HAT.get()).func_190903_i();
        plumeHeadStack.func_190925_c("display").func_74768_a("color", 12788538);
        this.func_184201_a(EquipmentSlotType.HEAD, plumeHeadStack);
        this.func_184201_a(EquipmentSlotType.MAINHAND, ((DyeableModSwordItem)ModWeapons.MACE.get()).func_190903_i());
    }

    @Override
    public void initStats() {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.HUMAN);
        worldData.addTemporaryCrewMember(ModNPCGroups.BUGGY_PIRATES, (LivingEntity)this);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(3.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        this.field_70714_bg.func_75776_a(0, (Goal)new ClimbOutOfHoleGoal((MobEntity)this));
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(1000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
        } else {
            this.devilFruitData.setDevilFruit(ModAbilities.SUBE_SUBE_NO_MI);
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(300.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(10.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(16.0);
        }
    }

    @Override
    public void initGoals() {
        MobsHelper.addBasicNPCGoals(this);
        SlamWrapperGoal slamWrapper = new SlamWrapperGoal((MobEntity)this);
        ((SlamAbility)slamWrapper.getAbility()).addComponents(new PoolComponent((IAbility)slamWrapper.getAbility(), ALVIDA, new AbilityPool2[0]));
        WeaponSpinWrapperGoal weaponSpinWrapper = new WeaponSpinWrapperGoal((MobEntity)this);
        ((WeaponSpinAbility)weaponSpinWrapper.getAbility()).addComponents(new PoolComponent((IAbility)weaponSpinWrapper.getAbility(), ALVIDA, new AbilityPool2[0]));
        this.standardPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.standardPhase.addGoal(2, slamWrapper);
        this.standardPhase.addGoal(2, weaponSpinWrapper);
        this.standardPhase.addGoal(2, new BattoStrikeWrapperGoal((MobEntity)this));
        this.getPhaseManager().setPhase(this.standardPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            BellyFlopWrapperGoal bellyFlopWrapper = new BellyFlopWrapperGoal((MobEntity)this);
            ((BellyFlopAbility)bellyFlopWrapper.getAbility()).addComponents(new PoolComponent((IAbility)bellyFlopWrapper.getAbility(), ALVIDA, new AbilityPool2[0]));
            ((BellyFlopAbility)bellyFlopWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 100.0f));
            this.standardPhase.addGoal(2, bellyFlopWrapper);
        } else {
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiImbuingWrapperGoal((MobEntity)this));
            this.standardPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 250.0f, 1.25f));
            this.standardPhase.addGoal(0, new GeppoWrapperGoal((MobEntity)this));
            this.standardPhase.addGoal(2, new SubeSubeSpurWrapperGoal((MobEntity)this));
            this.standardPhase.addGoal(2, new SubeSubeDeflectWrapperGoal((MobEntity)this));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.29f).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }
}

