/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.arlongpirates;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.AntiMannerKickCourseAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.ChargedPunchAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.HakaiHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.SuplexAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.KachiageHaisokuAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.KarakusagawaraSeikenAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.SamehadaShoteiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.DeadzoneRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.PhysicalHitRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.HumanoidSwimMoveController;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.FactionHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.TakedownKickWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.AntiMannerKickCourseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.PartyTableKickCourseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SpinningBrawlWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SuplexWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.KachiageHaisokuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.KarakusagawaraSeikenWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.SamehadaShoteiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KuroobiEntity
extends OPBossEntity<KuroobiEntity> {
    private static final UUID STANDARD_SUPLEX_COOLDOWN_UUID = UUID.fromString("91faa9f6-2082-4c39-acee-bd1468241742");
    private static final UUID HARD_SAMEHADA_COOLDOWN_UUID = UUID.fromString("de69810e-d16f-49d6-8951-240215fe6582");
    private static final UUID HARD_SAMEHADA_DAMAGE_UUID = UUID.fromString("56963b0c-5966-482e-b023-e439905e5146");
    private static final UUID HARD_CHARGED_PUNCH_CHARGING_UUID = UUID.fromString("4e9fd1ef-fce7-4ee5-b6c9-0b15142599b6");
    private RevengeMeter revengeMeter;
    private MovementController groundMovementController;
    private MovementController waterMovementController;
    private NPCPhase<KuroobiEntity> groundPhase;
    private NPCPhase<KuroobiEntity> waterPhase;

    public KuroobiEntity(EntityType type, World world) {
        super(type, world);
    }

    public KuroobiEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.KUROOBI.get(), challenge);
    }

    @Override
    public void initBoss() {
        this.revengeMeter = new RevengeMeter((LivingEntity)this, 100, 1);
        this.groundMovementController = new MovementController((MobEntity)this);
        this.waterMovementController = new HumanoidSwimMoveController((MobEntity)this);
        this.groundPhase = new SimplePhase<KuroobiEntity>("Ground Phase", this);
        this.waterPhase = new SimplePhase<KuroobiEntity>("Water Phase", this, this::startWaterPhaseEvent, this::stopWaterPhaseEvent);
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.FISHMAN);
        this.entityStats.setFightingStyle(ModValues.BRAWLER);
        ExtendedWorldData worldData = ExtendedWorldData.get();
        worldData.addTemporaryCrewMember(ModNPCGroups.ARLONG_PIRATES, (LivingEntity)this);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        this.getRevengeMeter().addCheck(new PhysicalHitRevengeCheck(2));
        this.getRevengeMeter().addCheck(new DeadzoneRevengeCheck(10));
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        Predicate<Entity> factionScope = ModEntityPredicates.getEnemyFactions((LivingEntity)this).and(ModEntityPredicates.IS_ENTITY_HARMLESS.negate());
        Predicate<Entity> invisibleCheck = factionScope.and(ModEntityPredicates.IS_INVISIBLE.negate());
        this.field_70715_bh.func_75776_a(1, (Goal)new FactionHurtByTargetGoal(this, factionScope, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, true, invisibleCheck));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, true, invisibleCheck));
        KachiageHaisokuWrapperGoal kachiageWrapper = new KachiageHaisokuWrapperGoal((MobEntity)this);
        ((KachiageHaisokuAbility)kachiageWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            ChargedPunchAbility abl = AbilityDataCapability.get(entity).getEquippedAbility(ChargedPunchAbility.INSTANCE);
            if (abl != null && abl.isCharging()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        ((KachiageHaisokuAbility)kachiageWrapper.getAbility()).getComponent(ModAbilityKeys.DAMAGE).ifPresent(comp -> {
            LivingEntity lastHit;
            if (this.waterPhase.isActive(this) && (lastHit = comp.getLastTarget()) != null) {
                AbilityHelper.setDeltaMovement((Entity)lastHit, this.func_213322_ci().field_72450_a, -2.0, this.func_213322_ci().field_72449_c);
            }
        });
        ChargedPunchWrapperGoal chargedPunchWrapper = new ChargedPunchWrapperGoal((MobEntity)this);
        ((ChargedPunchAbility)chargedPunchWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            KachiageHaisokuAbility kachiage = AbilityDataCapability.get(entity).getEquippedAbility(KachiageHaisokuAbility.INSTANCE);
            SamehadaShoteiAbility samehada = AbilityDataCapability.get(entity).getEquippedAbility(SamehadaShoteiAbility.INSTANCE);
            if (kachiage != null && kachiage.isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            if (samehada != null && samehada.isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        SamehadaShoteiWrapperGoal samehadaWrapper = new SamehadaShoteiWrapperGoal((MobEntity)this);
        KarakusagawaraSeikenWrapperGoal karakusagawaraWrapper = new KarakusagawaraSeikenWrapperGoal((MobEntity)this);
        ((KarakusagawaraSeikenAbility)karakusagawaraWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 100.0f));
        SuplexWrapperGoal suplexWrapper = new SuplexWrapperGoal((MobEntity)this);
        ((SuplexAbility)suplexWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            SamehadaShoteiAbility abl = AbilityDataCapability.get(entity).getEquippedAbility(SamehadaShoteiAbility.INSTANCE);
            if (abl != null && abl.isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        ((SuplexAbility)suplexWrapper.getAbility()).getComponent(ModAbilityKeys.CHARGE).ifPresent(comp -> comp.addTickEvent(90, (entity, ability) -> {
            if (!this.waterPhase.isActive(this) || comp.getChargePercentage() < 0.8f) {
                return;
            }
            LivingEntity target = ((SuplexAbility)suplexWrapper.getAbility()).getComponent(ModAbilityKeys.GRAB).flatMap(grabComp -> Optional.ofNullable(grabComp.getGrabbedEntity())).orElse(null);
            if (target != null) {
                AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci().func_72441_c(0.0, -1.3, 0.0));
            }
        }));
        this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<FishmanPassiveBonusesAbility>((MobEntity)this, FishmanPassiveBonusesAbility.INSTANCE));
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.groundPhase.addGoal(1, new SprintTowardsTargetGoal((MobEntity)this));
        this.groundPhase.addGoal(3, new TakedownKickWrapperGoal((MobEntity)this));
        this.groundPhase.addGoal(3, suplexWrapper);
        this.groundPhase.addGoal(4, samehadaWrapper);
        this.groundPhase.addGoal(4, chargedPunchWrapper);
        this.groundPhase.addGoal(4, kachiageWrapper);
        this.groundPhase.addGoal(5, karakusagawaraWrapper);
        this.waterPhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 120.0f, 5.0f));
        this.waterPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 100.0f, 2.25f));
        this.waterPhase.addGoal(3, suplexWrapper);
        this.waterPhase.addGoal(4, chargedPunchWrapper);
        this.waterPhase.addGoal(4, kachiageWrapper);
        this.waterPhase.addGoal(5, karakusagawaraWrapper);
        this.getPhaseManager().setPhase(this.groundPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(2.0);
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
            this.getRevengeMeter().addCheck(new DeadzoneRevengeCheck(5));
            ((KarakusagawaraSeikenAbility)karakusagawaraWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
                if ((double)entity.func_110143_aJ() <= WyHelper.percentage(30.0, entity.func_110138_aP())) {
                    return AbilityUseResult.success();
                }
                return AbilityUseResult.fail(null);
            });
            ((SuplexAbility)suplexWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(STANDARD_SUPLEX_COOLDOWN_UUID, "Standard Suplex Cooldown Bonus", BonusOperation.ADD, 40.0f));
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(5.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(5.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(7.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(350.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(5.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(16.0);
            this.getRevengeMeter().addCheck(new DeadzoneRevengeCheck(10));
            ((SamehadaShoteiAbility)samehadaWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_SAMEHADA_COOLDOWN_UUID, "Hard Samehada Cooldown Bonus", BonusOperation.MUL, 0.75f));
            ((SamehadaShoteiAbility)samehadaWrapper.getAbility()).getComponent(ModAbilityKeys.DAMAGE).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_SAMEHADA_DAMAGE_UUID, "Hard Samehada Damage Bonus", BonusOperation.MUL, 2.0f));
            ((ChargedPunchAbility)chargedPunchWrapper.getAbility()).getComponent(ModAbilityKeys.CHARGE).ifPresent(comp -> comp.getMaxChargeBonusManager().addBonus(HARD_CHARGED_PUNCH_CHARGING_UUID, "Hard Charged Punch Charging Bonus", BonusOperation.MUL, 0.5f));
            HakaiHoWrapperGoal hakaiHoWrapper = new HakaiHoWrapperGoal((MobEntity)this);
            ((HakaiHoAbility)hakaiHoWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 100.0f));
            ((HakaiHoAbility)hakaiHoWrapper.getAbility()).getComponent(ModAbilityKeys.DAMAGE).ifPresent(comp -> {
                LivingEntity lastHit;
                if (this.waterPhase.isActive(this) && (lastHit = comp.getLastTarget()) != null) {
                    AbilityHelper.setDeltaMovement((Entity)lastHit, this.func_213322_ci().field_72450_a, -2.0, this.func_213322_ci().field_72449_c);
                }
            });
            AntiMannerKickCourseWrapperGoal antiMannerWrapper = new AntiMannerKickCourseWrapperGoal((MobEntity)this);
            AnimationComponent antiMannerAnimationComp = new AnimationComponent((IAbility)antiMannerWrapper.getAbility());
            ((AntiMannerKickCourseAbility)antiMannerWrapper.getAbility()).addComponents(antiMannerAnimationComp);
            ((AntiMannerKickCourseAbility)antiMannerWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 120.0f));
            ((AntiMannerKickCourseAbility)antiMannerWrapper.getAbility()).getComponent(ModAbilityKeys.DAMAGE).ifPresent(comp -> {
                LivingEntity lastHit;
                if (this.waterPhase.isActive(this) && (lastHit = comp.getLastTarget()) != null) {
                    antiMannerAnimationComp.start((LivingEntity)this, ModAnimations.TAKEDOWN_KICK, 7);
                    AbilityHelper.setDeltaMovement((Entity)lastHit, this.func_213322_ci().field_72450_a, -2.0, this.func_213322_ci().field_72449_c);
                }
            });
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.groundPhase.addGoal(3, new PartyTableKickCourseWrapperGoal((MobEntity)this));
            this.groundPhase.addGoal(3, antiMannerWrapper);
            this.groundPhase.addGoal(3, hakaiHoWrapper);
            this.groundPhase.addGoal(3, new SpinningBrawlWrapperGoal((MobEntity)this));
            this.waterPhase.addGoal(3, antiMannerWrapper);
            this.waterPhase.addGoal(3, hakaiHoWrapper);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.29f).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233818_a_, 250.0).func_233815_a_(Attributes.field_233820_c_, 0.2);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.getRevengeMeter().tick();
            if (this.func_70090_H()) {
                this.getPhaseManager().setPhase(this.waterPhase);
            } else {
                this.getPhaseManager().setPhase(this.groundPhase);
            }
        }
    }

    private void startWaterPhaseEvent(KuroobiEntity entity) {
        this.field_70765_h = this.waterMovementController;
    }

    private void stopWaterPhaseEvent(KuroobiEntity entity) {
        this.field_70765_h = this.groundMovementController;
    }

    @Override
    public RevengeMeter getRevengeMeter() {
        return this.revengeMeter;
    }
}

