/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.buggypirates;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.abilities.BombThrowAbility;
import xyz.pixelatedw.mineminenomi.abilities.SlashDamageImmunityAbility;
import xyz.pixelatedw.mineminenomi.abilities.bara.BaraBaraCarAbility;
import xyz.pixelatedw.mineminenomi.abilities.bara.BaraBaraFestivalAbility;
import xyz.pixelatedw.mineminenomi.abilities.bara.BaraBaraHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.bara.BaraSplitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.DeadzoneRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.TargetFlyStallingRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.TargetRunningAwayRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.BombEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ClimbOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.BombThrowWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bara.BaraBaraCarWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bara.BaraBaraFestivalWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bara.BaraBaraHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bara.BaraSplitWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.KenbunshokuHakiFutureSightWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.buggy.BuggyDashGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.buggy.BuggyPhaseSwitcherGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.buggy.BuggyRunningGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BuggyEntity
extends OPBossEntity<BuggyEntity> {
    private static final byte BARA_RESET_EVENT = 100;
    private static final byte BARA_HO_EVENT = 101;
    private static final byte BARA_SPLIT_EVENT = 102;
    private static final byte BARA_FESTIVAL_EVENT = 103;
    private static final byte BARA_CAR_START_EVENT = 104;
    private static final byte BARA_CAR_END_EVENT = 105;
    private static final byte FIREWORKS_EVENT = 110;
    private static final CompoundNBT FIREWORKS_TAG = BuggyEntity.createFireworksTag();
    private static final UUID BARA_CAR_COOLDOWN_UUID = UUID.fromString("1d375261-e119-484c-8df3-c92da926cd6c");
    public int clientCarState = 0;
    public int clientState = 0;
    private int clientTick = 0;
    private boolean tickClient = false;
    private NPCPhase<BuggyEntity> normalPhase = new SimplePhase<BuggyEntity>("Normal Phase", this);
    private NPCPhase<BuggyEntity> carPhase = new SimplePhase<BuggyEntity>("Car Phase", this);
    private final RevengeMeter kitingMeter = new RevengeMeter((LivingEntity)this, 100, 0);
    private BaraBaraFestivalWrapperGoal baraFestivalWrapper;
    private BaraBaraCarWrapperGoal baraCarWrapper;
    private boolean splitBombs = false;

    public BuggyEntity(EntityType type, World world) {
        super(type, world);
    }

    public BuggyEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.BUGGY.get(), challenge);
    }

    @Override
    public void initBoss() {
        ItemStack capeStack = new ItemStack((IItemProvider)ModArmors.PIRATE_CAPTAIN_CAPE.get());
        capeStack.func_190925_c("display").func_74768_a("color", 16146690);
        ItemStack bicorneStack = ((Item)ModArmors.BICORNE.get()).func_190903_i();
        bicorneStack.func_190925_c("display").func_74768_a("color", 13459968);
        this.func_184201_a(EquipmentSlotType.HEAD, bicorneStack);
        this.func_184201_a(EquipmentSlotType.CHEST, capeStack);
    }

    @Override
    public void initStats() {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.HUMAN);
        this.devilFruitData.setDevilFruit(ModAbilities.BARA_BARA_NO_MI);
        worldData.addTemporaryCrewMember(ModNPCGroups.BUGGY_PIRATES, (LivingEntity)this);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(4.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(300.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(10.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(16.0);
        }
    }

    @Override
    public void initGoals() {
        MobsHelper.addBasicNPCGoals(this);
        BaraBaraHoWrapperGoal baraHoWrapper = new BaraBaraHoWrapperGoal((MobEntity)this);
        ((BaraBaraHoAbility)baraHoWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> {
            comp.addStartEvent((e, a) -> {
                this.field_70170_p.func_72960_a((Entity)this, (byte)101);
                this.clientTick = 20;
                this.tickClient = true;
            });
            comp.addTickEvent((e, a) -> {
                if (this.tickClient && this.clientTick-- <= 0) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)100);
                    this.tickClient = false;
                }
            });
        });
        ((BaraBaraHoAbility)baraHoWrapper.getAbility()).getComponent(ModAbilityKeys.PROJECTILE).ifPresent(comp -> comp.addAfterShootEvent(100, e -> this.field_70170_p.func_72960_a((Entity)this, (byte)100)));
        this.baraFestivalWrapper = new BaraBaraFestivalWrapperGoal((MobEntity)this);
        ((BaraBaraFestivalAbility)this.baraFestivalWrapper.getAbility()).addTickEvent((e, a) -> {
            LivingEntity target = this.func_70638_az();
            if (target != null) {
                boolean hasRecentHit = this.func_142015_aE() > 0 && this.field_70170_p.func_82737_E() - (long)this.func_142015_aE() > 100L;
                boolean hasEnemyNearby = GoalUtil.isWithinDistance((LivingEntity)this, target, 5.0);
                if (hasRecentHit && hasEnemyNearby) {
                    ((BaraBaraFestivalAbility)this.baraFestivalWrapper.getAbility()).switchModeToShield((LivingEntity)this);
                } else {
                    ((BaraBaraFestivalAbility)this.baraFestivalWrapper.getAbility()).switchModeToAttack((LivingEntity)this);
                }
            }
        });
        ((BaraBaraFestivalAbility)this.baraFestivalWrapper.getAbility()).getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> {
            comp.addStartEvent((e, a) -> this.field_70170_p.func_72960_a((Entity)this, (byte)103));
            comp.addEndEvent((e, a) -> this.field_70170_p.func_72960_a((Entity)this, (byte)100));
        });
        BaraSplitWrapperGoal baraSplitWrapper = new BaraSplitWrapperGoal((MobEntity)this);
        ((BaraSplitAbility)baraSplitWrapper.getAbility()).addCanUseCheck((e, a) -> {
            if (GoalUtil.isOutsideDistance((LivingEntity)this, this.func_70638_az(), 20.0)) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        ((BaraSplitAbility)baraSplitWrapper.getAbility()).getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(this::setBaraSplitLogic);
        BombThrowWrapperGoal bombThrowWrapper = new BombThrowWrapperGoal((MobEntity)this);
        ((BombThrowAbility)bombThrowWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(BARA_CAR_COOLDOWN_UUID, "Bara Car Cooldown Bonus", BonusOperation.MUL, 0.5f));
        this.baraCarWrapper = new BaraBaraCarWrapperGoal((MobEntity)this);
        Predicate<LivingEntity> canDash = entity -> {
            if (((BaraBaraCarAbility)this.baraCarWrapper.getAbility()).isContinuous()) {
                return false;
            }
            return !((BaraSplitAbility)baraSplitWrapper.getAbility()).isContinuous();
        };
        this.kitingMeter.addCheck(new TargetFlyStallingRevengeCheck(1));
        this.kitingMeter.addCheck(new TargetRunningAwayRevengeCheck(10, 10.0f));
        this.kitingMeter.addCheck(new DeadzoneRevengeCheck(5));
        this.field_70714_bg.func_75776_a(0, (Goal)new ClimbOutOfHoleGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new BuggyPhaseSwitcherGoal(this));
        this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<SlashDamageImmunityAbility>((MobEntity)this, SlashDamageImmunityAbility.BARA_INSTANCE));
        this.normalPhase.addGoal(0, new BuggyRunningGoal(this, 1.5));
        this.normalPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.normalPhase.addGoal(2, baraHoWrapper);
        this.normalPhase.addGoal(2, this.baraFestivalWrapper);
        this.normalPhase.addGoal(2, bombThrowWrapper);
        this.normalPhase.addGoal(3, baraSplitWrapper);
        this.carPhase.addGoal(0, new BuggyRunningGoal(this, 2.5));
        this.carPhase.addGoal(2, bombThrowWrapper);
        this.getPhaseManager().setPhase(this.normalPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.normalPhase.addGoal(1, new DashDodgeTargetGoal((MobEntity)this, 500.0f, 2.0f).setCanUseTest(canDash));
            this.normalPhase.addGoal(1, new DashDodgeProjectilesGoal((MobEntity)this, 500.0f, 2.0f).setCanUseTest(canDash));
            this.carPhase.addGoal(0, new BuggyDashGoal(this, 2.5, 10.0f));
        } else {
            this.field_70714_bg.func_75776_a(0, (Goal)new KenbunshokuHakiFutureSightWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.normalPhase.addGoal(1, new DashDodgeTargetGoal((MobEntity)this, 250.0f, 3.0f).setCanUseTest(canDash));
            this.normalPhase.addGoal(1, new DashDodgeProjectilesGoal((MobEntity)this, 250.0f, 3.0f).setCanUseTest(canDash));
            this.carPhase.addGoal(0, new BuggyDashGoal(this, 5.0, 25.0f));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    public EntitySize func_213305_a(Pose pose) {
        if (this.isCarPhaseActive() || this.clientCarState == 1) {
            return EntitySize.func_220311_c((float)1.3f, (float)0.9f);
        }
        return super.func_213305_a(pose);
    }

    @Override
    public void func_70071_h_() {
        this.field_70143_R = 0.0f;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.kitingMeter.tick();
        }
        if (this.isCarPhaseActive() || this.clientCarState == 1) {
            this.func_213323_x_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 110: {
                this.field_70170_p.func_92088_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0, FIREWORKS_TAG);
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                this.clientState = id - 100;
                break;
            }
            case 104: {
                this.clientState = 4;
                this.clientCarState = 1;
                break;
            }
            case 105: {
                this.clientState = 4;
                this.clientCarState = -1;
            }
        }
        super.func_70103_a(id);
    }

    private static CompoundNBT createFireworksTag() {
        CompoundNBT fireworkData = new CompoundNBT();
        ListNBT explosionList = new ListNBT();
        CompoundNBT explosion1Data = new CompoundNBT();
        explosion1Data.func_74768_a("Type", 1);
        explosion1Data.func_74757_a("Flicker", true);
        explosion1Data.func_74783_a("Colors", new int[]{16351261, 11546150});
        explosion1Data.func_74783_a("FadeColors", new int[]{16701501, 0xF9FFFE});
        CompoundNBT explosion2Data = new CompoundNBT();
        explosion2Data.func_74768_a("Type", 4);
        explosion2Data.func_74757_a("Trail", true);
        explosion2Data.func_74783_a("Colors", new int[]{16701501, 0xF9FFFE});
        explosionList.add((Object)explosion1Data);
        explosionList.add((Object)explosion2Data);
        fireworkData.func_218657_a("Explosions", (INBT)explosionList);
        return fireworkData;
    }

    public boolean shouldRun() {
        boolean isCarActive = this.getPhaseManager().isCurrentPhase(this.carPhase);
        if (isCarActive) {
            return true;
        }
        boolean isFestivalActive = ((BaraBaraFestivalAbility)this.baraFestivalWrapper.getAbility()).getComponent(ModAbilityKeys.CONTINUOUS).map(comp -> comp.isContinuous()).orElse(false);
        boolean isFestivalAttackMode = ((BaraBaraFestivalAbility)this.baraFestivalWrapper.getAbility()).isAttackMode();
        return isFestivalActive && isFestivalAttackMode;
    }

    private void setBaraSplitLogic(ContinuousComponent comp) {
        comp.addStartEvent(101, (e, a) -> {
            this.splitBombs = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)102);
            this.func_195063_d((Effect)ModEffects.MOVEMENT_BLOCKED.get());
            AbilityHelper.setDeltaMovement((Entity)this, 0.0, 1.5, 0.0);
            List<LivingEntity> targets = TargetHelper.getEntitiesInArea((LivingEntity)this, 3.0, TargetsPredicate.DEFAULT_AREA_CHECK, LivingEntity.class);
            for (LivingEntity target : targets) {
                Vector3d speed = this.func_70040_Z().func_216372_d(2.5, 1.0, 2.5);
                AbilityHelper.setDeltaMovement((Entity)target, speed.field_72450_a, 0.25, speed.field_72449_c);
            }
        });
        comp.addTickEvent((e, a) -> {
            BombEntity bomb;
            Vector3d dirVec;
            Vector3d pos;
            double z;
            double x;
            double phi;
            if (this.splitBombs || comp.getContinueTime() < 20.0f) {
                return;
            }
            boolean hasSecondWave = false;
            int radius = 3;
            int bombs = 4;
            if (this.isDifficultyHardOrAbove()) {
                bombs = 12;
                radius = 5;
                hasSecondWave = true;
            } else if ((double)this.func_110143_aJ() < WyHelper.percentage(40.0, this.func_110138_aP())) {
                bombs = 8;
            }
            if (bombs <= 0) {
                return;
            }
            if (hasSecondWave) {
                for (phi = 0.0; phi <= Math.PI * 2; phi += Math.PI / ((double)bombs / 2.0)) {
                    x = (double)radius / 2.0 * Math.cos(phi) + WyHelper.randomDouble() / 5.0;
                    z = (double)radius / 2.0 * Math.sin(phi) + WyHelper.randomDouble() / 5.0;
                    pos = this.func_213303_ch().func_178787_e(new Vector3d(x, this.func_213303_ch().field_72448_b, z));
                    dirVec = this.func_213303_ch().func_178788_d(pos).func_72432_b().func_216372_d(7.5, 1.0, 7.5);
                    bomb = new BombEntity(this.field_70170_p, (LivingEntity)this);
                    bomb.setExplodeOnImpact();
                    bomb.func_70012_b(this.func_213303_ch().field_72450_a + x, this.func_213303_ch().field_72448_b, this.func_213303_ch().field_72449_c + z, this.func_70681_au().nextInt(360), this.func_70681_au().nextInt(360));
                    AbilityHelper.setDeltaMovement(bomb, -dirVec.field_72450_a, 1.0, -dirVec.field_72449_c);
                    this.field_70170_p.func_217376_c((Entity)bomb);
                }
            }
            for (phi = 0.0; phi <= Math.PI * 2; phi += Math.PI / (double)bombs) {
                x = (double)radius * Math.cos(phi) + WyHelper.randomDouble() / 5.0;
                z = (double)radius * Math.sin(phi) + WyHelper.randomDouble() / 5.0;
                pos = this.func_213303_ch().func_178787_e(new Vector3d(x, this.func_213303_ch().field_72448_b, z));
                dirVec = this.func_213303_ch().func_178788_d(pos).func_72432_b().func_216372_d(7.5, 1.0, 7.5);
                bomb = new BombEntity(this.field_70170_p, (LivingEntity)this);
                bomb.setExplodeOnImpact();
                bomb.func_70012_b(this.func_213303_ch().field_72450_a + x, this.func_213303_ch().field_72448_b, this.func_213303_ch().field_72449_c + z, this.func_70681_au().nextInt(360), this.func_70681_au().nextInt(360));
                AbilityHelper.setDeltaMovement(bomb, -dirVec.field_72450_a, 1.0, -dirVec.field_72449_c);
                this.field_70170_p.func_217376_c((Entity)bomb);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)110);
            this.splitBombs = true;
        });
        comp.addEndEvent((e, a) -> this.field_70170_p.func_72960_a((Entity)this, (byte)100));
    }

    public void startNormalPhase() {
        this.getPhaseManager().setPhase(this.normalPhase);
        this.field_70170_p.func_72960_a((Entity)this, (byte)105);
    }

    public void startCarPhase() {
        this.getPhaseManager().setPhase(this.carPhase);
        this.field_70170_p.func_72960_a((Entity)this, (byte)104);
        this.kitingMeter.reduceRevengeValue(-10);
    }

    public boolean isNormalPhaseActive() {
        return this.normalPhase.isActive(this);
    }

    public boolean isCarPhaseActive() {
        if (this.carPhase == null) {
            return false;
        }
        return this.carPhase.isActive(this);
    }

    public float getKitingMeterCompletion() {
        return this.kitingMeter.getRevengePercentage();
    }
}

