/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.abilities.PearlFireAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.TekkaiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.PhysicalHitRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.BellyFlopWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.PearlFireWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.JishinHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.TekkaiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PearlEntity
extends OPBossEntity<PearlEntity> {
    private static final AttributeModifier ATTACK_MODIFIER = new AttributeModifier(UUID.fromString("989e4cf0-cada-442c-b6e1-c3eddca0545f"), "Attack Damage Bonus", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier PUNCH_MODIFIER = new AttributeModifier(UUID.fromString("2cba6879-f98d-404f-b169-0d3e2a3dd903"), "Punch Damage Bonus", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier ARMOR_TOUGHNESS_MODIFIER = new AttributeModifier(UUID.fromString("30afa6b8-6318-428b-89a8-fad41d228d3a"), "Armor Toughness Bonus", 2.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final UUID REVENGE_ATTACK_MODIFIER = UUID.fromString("127f4823-6440-4175-b590-5011b2fbe67c");
    private static final UUID REVENGE_PUNCH_MODIFIER = UUID.fromString("dba9b47e-8611-4245-a7e5-f46f7a0924e3");
    private RevengeMeter revengeMeter;
    private NPCPhase<PearlEntity> normalPhase;
    private NPCPhase<PearlEntity> flamingPhase;
    private int tekkaiAbuseStartCounter;
    private int tekkaiWaitCounter;
    private int prevRevengeVal;

    public PearlEntity(EntityType type, World world) {
        super(type, world);
    }

    public PearlEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.PEARL.get(), challenge);
    }

    @Override
    public void initBoss() {
        this.revengeMeter = new RevengeMeter((LivingEntity)this, 1000, 1);
        this.normalPhase = new SimplePhase<PearlEntity>("Normal Phase", this);
        this.flamingPhase = new SimplePhase<PearlEntity>("Flaming Phase", this, this::startFlamingPhaseEvent, this::stopFlamingPhaseEvent);
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.HUMAN);
        this.entityStats.setFightingStyle(ModValues.BRAWLER);
        ExtendedWorldData worldData = ExtendedWorldData.get();
        worldData.addTemporaryCrewMember(ModNPCGroups.KRIEG_PIRATES, (LivingEntity)this);
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModArmors.PEARL_HAT.get()));
        this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)ModArmors.PEARL_ARMOR.get()));
        this.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)ModArmors.PEARL_LEGS.get()));
        this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(1.1);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(1.5);
        this.getRevengeMeter().addCheck(new PhysicalHitRevengeCheck(5));
        ChargedPunchWrapperGoal chargedPunchWrapper = new ChargedPunchWrapperGoal((MobEntity)this);
        TekkaiWrapperGoal tekkaiWrapper = new TekkaiWrapperGoal((MobEntity)this);
        ((TekkaiAbility)tekkaiWrapper.getAbility()).getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> {
            comp.addStartEvent(110, (entity, ability) -> {
                this.tekkaiWaitCounter = 0;
                this.tekkaiAbuseStartCounter = this.revengeMeter.countCheckTriggers(PhysicalHitRevengeCheck.class);
            });
            comp.addTickEvent(110, (entity, ability) -> {
                if (this.field_70173_aa % 10 == 0) {
                    List targets = TargetHelper.getEntitiesInArea((LivingEntity)this, 7.0, TargetsPredicate.DEFAULT_AREA_CHECK, LivingEntity.class);
                    if (targets.size() > 0) {
                        this.tekkaiWaitCounter += targets.size();
                    }
                    int currentCounter = this.revengeMeter.countCheckTriggers(PhysicalHitRevengeCheck.class);
                    if (this.tekkaiWaitCounter > 6 || currentCounter >= this.tekkaiAbuseStartCounter + 5) {
                        double pushPower = this.isDifficultyHard() ? 7.0 : 5.0;
                        this.pushEnemiesAway(pushPower);
                        this.resetCooldowns();
                        this.getRevengeMeter().addRevengeValue(30);
                        comp.stopContinuity((LivingEntity)this);
                    }
                }
            });
        });
        PearlFireWrapperGoal pearlFireWrapper = new PearlFireWrapperGoal((MobEntity)this);
        ((PearlFireAbility)pearlFireWrapper.getAbility()).getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> comp.addTickEvent((entity, ability) -> comp.increaseContinuityTime(2.0f)));
        MobsHelper.addBasicNPCGoals(this);
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)chargedPunchWrapper);
        this.field_70714_bg.func_75776_a(2, (Goal)tekkaiWrapper);
        this.flamingPhase.addGoal(0, pearlFireWrapper);
        this.getPhaseManager().setPhase(this.normalPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(250.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(16.0);
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new HakaiHoWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new JishinHoWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new BellyFlopWrapperGoal((MobEntity)this));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.28f).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233827_j_, 4.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233825_h_, 3.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.getRevengeMeter().tick();
            if (this.field_70173_aa % 10 == 0) {
                int revengeVal;
                int physicalHits = this.getRevengeMeter().countCheckTriggers(PhysicalHitRevengeCheck.class);
                if (this.normalPhase.isActive(this) && ((double)this.func_110143_aJ() <= WyHelper.percentage(30.0, this.func_110138_aP()) || physicalHits >= 20)) {
                    this.getPhaseManager().setPhase(this.flamingPhase);
                }
                if (this.flamingPhase.isActive(this) && (this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b() || this.func_184582_a(EquipmentSlotType.CHEST).func_190926_b() || this.func_184582_a(EquipmentSlotType.LEGS).func_190926_b())) {
                    this.getPhaseManager().setPhase(this.normalPhase);
                }
                if (this.isDifficultyHard() && (revengeVal = this.getRevengeMeter().getRevengeValue()) > 10 && revengeVal != this.prevRevengeVal) {
                    this.prevRevengeVal = revengeVal;
                    double damageBonus = (double)revengeVal / 15.0;
                    this.func_110148_a(Attributes.field_233823_f_).func_188479_b(REVENGE_ATTACK_MODIFIER);
                    this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_188479_b(REVENGE_PUNCH_MODIFIER);
                    this.func_110148_a(Attributes.field_233823_f_).func_233767_b_(new AttributeModifier(REVENGE_ATTACK_MODIFIER, "Revenge Attack Bonus", damageBonus, AttributeModifier.Operation.ADDITION));
                    this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_233767_b_(new AttributeModifier(REVENGE_PUNCH_MODIFIER, "Revenge Punch Bonus", damageBonus, AttributeModifier.Operation.ADDITION));
                }
            }
        }
    }

    private void startFlamingPhaseEvent(PearlEntity entity) {
        this.func_110148_a(Attributes.field_233823_f_).func_233767_b_(ATTACK_MODIFIER);
        this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_233767_b_(PUNCH_MODIFIER);
        this.func_110148_a(Attributes.field_233827_j_).func_233767_b_(ARMOR_TOUGHNESS_MODIFIER);
        this.pushEnemiesAway(5.0);
    }

    private void stopFlamingPhaseEvent(PearlEntity entity) {
        this.func_110148_a(Attributes.field_233823_f_).func_111124_b(ATTACK_MODIFIER);
        this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111124_b(PUNCH_MODIFIER);
        this.func_110148_a(Attributes.field_233827_j_).func_111124_b(ARMOR_TOUGHNESS_MODIFIER);
    }

    private void pushEnemiesAway(double power) {
        List<LivingEntity> targets = TargetHelper.getEntitiesInArea((LivingEntity)this, 15.0, TargetsPredicate.DEFAULT_AREA_CHECK, LivingEntity.class);
        for (LivingEntity target : targets) {
            Vector3d dirVec = target.func_213303_ch().func_178788_d(this.func_213303_ch()).func_72432_b().func_216372_d(power, 1.0, power);
            AbilityHelper.setDeltaMovement((Entity)target, dirVec.field_72450_a, 0.0, dirVec.field_72449_c);
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BERSERKER_POWERUP.get(), (Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    private void resetCooldowns() {
        for (IAbility ability : AbilityDataCapability.get((LivingEntity)this).getEquippedAbilities()) {
            if (ability == null) continue;
            ability.getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.stopCooldown((LivingEntity)this));
        }
    }

    @Override
    public RevengeMeter getRevengeMeter() {
        return this.revengeMeter;
    }
}

