/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.brawler.BrawlerPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.GenkotsuMeteorAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.SuplexAbility;
import xyz.pixelatedw.mineminenomi.api.entities.TrainerEntity;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.GenkotsuMeteorWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.JishinHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SpinningBrawlWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SuplexWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.IHakiTrainer;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BrawlerTrainerEntity
extends TrainerEntity
implements IHakiTrainer {
    public BrawlerTrainerEntity(EntityType type, World world) {
        super(type, world, MobsHelper.BRAWLER_TRAINER_TEXTURES);
        if (world != null && !world.field_72995_K) {
            this.getEntityStats().setFaction(ModValues.CIVILIAN);
            this.getEntityStats().setFightingStyle(ModValues.BRAWLER);
            this.getEntityStats().setRace(ModValues.HUMAN);
            this.setDoriki(2000.0 + WyHelper.randomWithRange(0, 1000));
            this.setBelly(20.0 + WyHelper.randomWithRange(0, 20));
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(12.0);
            this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true, true));
            this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<BrawlerPassiveBonusesAbility>((MobEntity)this, BrawlerPassiveBonusesAbility.INSTANCE));
            this.field_70714_bg.func_75776_a(0, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.2, true));
            WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
            goals.addEntry(() -> new HakaiHoWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new JishinHoWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new ChargedPunchWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> {
                GenkotsuMeteorWrapperGoal goal = new GenkotsuMeteorWrapperGoal((MobEntity)this);
                ((GenkotsuMeteorAbility)goal.getAbility()).addCanUseCheck(TrainerEntity.BELOW_90_CHECK);
                return goal;
            }, 2.0f);
            goals.addEntry(() -> new SpinningBrawlWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> {
                SuplexWrapperGoal goal = new SuplexWrapperGoal((MobEntity)this);
                ((SuplexAbility)goal.getAbility()).addCanUseCheck(TrainerEntity.BELOW_90_CHECK);
                return goal;
            }, 2.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, 5, goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
            MobsHelper.addBusoshokuHaki((MobEntity)this, 100);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233826_i_, 15.0);
    }

    @Override
    public List<QuestId> getAvailableQuests(PlayerEntity player) {
        IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
        ArrayList<QuestId> availableQuests = new ArrayList<QuestId>();
        if (entityProps.isBrawler()) {
            availableQuests.addAll(ModQuests.BRAWLER_TRIALS);
        }
        return availableQuests;
    }

    @Override
    public HakiType getTrainingHaki() {
        return HakiType.BUSOSHOKU;
    }
}

