/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModIndirectEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.events.ProjectileBlockEvent;
import xyz.pixelatedw.mineminenomi.api.events.ProjectileHitEvent;
import xyz.pixelatedw.mineminenomi.api.events.ProjectileShootEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.entities.SphereEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.bari.BariProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateProjBlockCollisionBox;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateProjEntityCollisionBox;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class AbilityProjectileEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    private int maxLife = 64;
    private int knockbackStrength = 0;
    private float damage = 0.1f;
    private float gravity = 1.0E-4f;
    private boolean canPassThroughBlocks = false;
    private boolean canPassThroughEntities = false;
    @Deprecated
    private boolean canGetStuckInGround = false;
    protected boolean stuckInGround = false;
    private boolean changeHurtTime = false;
    private float armorPiercing = 0.0f;
    private boolean unavoidable;
    private boolean canHurtThrower = false;
    private boolean isFake = false;
    private boolean hasVelocityRotation = true;
    private boolean canCollideWithEntities = true;
    private boolean canCollideWithBlocks = true;
    private int hurtTime = 10;
    protected boolean entityDamaged = false;
    protected boolean firstEntityImpact = true;
    private boolean applyOnlyOnce = true;
    private List<Integer> targets = new ArrayList<Integer>();
    private int targetResetTime = 20;
    private int blocksAffectedLimit = 4096;
    private int blocksAffected = 0;
    private boolean removeOnBlockLimit = true;
    private boolean hasBlockDestructionLimit = true;
    private SourceHakiNature sourceHakiNature = SourceHakiNature.UNKNOWN;
    private SourceElement sourceElement = SourceElement.NONE;
    private ArrayList<SourceType> sourceTypes = new ArrayList();
    private AxisAlignedBB entityCollisionBox = this.getDefaultBoundingBox();
    private AxisAlignedBB blockCollisionBox = this.getDefaultBoundingBox();
    private final Predicate<Entity> entityPredicate = target -> {
        if (target == this) {
            return false;
        }
        if (target instanceof ExperienceOrbEntity || target instanceof ItemEntity) {
            return false;
        }
        if (target instanceof LivingEntity && target.func_241845_aY() && target != this.getThrower() && ModEntityPredicates.getEnemyFactions(this.getThrower()).test((Entity)target)) {
            return ((LivingEntity)target).func_70685_l((Entity)this);
        }
        return !(target instanceof ProjectileEntity) || ((ProjectileEntity)target).func_234616_v_() == null || ((ProjectileEntity)target).func_234616_v_() != this.getThrower();
    };
    private final Predicate<Entity> collisionPredicate = ModEntityPredicates.IS_ALIVE_AND_SURVIVAL.and(e -> !(e instanceof SphereEntity)).and(this.entityPredicate);
    private final Interval lightningDischargeInterval = new Interval(10);
    @Nullable
    private AbilityCore<? extends Ability> parent;
    private static final DataParameter<Integer> OWNER = EntityDataManager.func_187226_a(AbilityProjectileEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(AbilityProjectileEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_GLOWING = EntityDataManager.func_187226_a(AbilityProjectileEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public IOnEntityImpact onEntityImpactEvent = hitEntity -> {
        if (this.firstEntityImpact) {
            this.onBlockImpactEvent.onImpact(hitEntity.func_233580_cy_());
        }
    };
    public IOnBlockImpact onBlockImpactEvent;
    public IOnTick onTickEvent;
    @Deprecated
    public IWithEffects withEffects;
    private ModDamageSource source;
    @Deprecated
    public ModDamageSource bypassingSource;
    private final ArrayList<Block> ignorableBlocks;

    public AbilityProjectileEntity(EntityType type, World world) {
        super(type, world);
        this.onBlockImpactEvent = hit -> {};
        this.onTickEvent = () -> {};
        this.withEffects = () -> new EffectInstance[0];
        this.ignorableBlocks = new ArrayList<Block>(Arrays.asList(Blocks.field_196800_gd, Blocks.field_150349_c, Blocks.field_196804_gh, Blocks.field_203198_aQ, Blocks.field_203214_jx, Blocks.field_203215_jy, Blocks.field_203199_aR, Blocks.field_150395_bd, Blocks.field_150488_af, Blocks.field_196555_aI, Blocks.field_196802_gf, (Block)ModBlocks.OPE.get()));
    }

    public AbilityProjectileEntity(EntityType type, World world, double x, double y, double z) {
        super(type, x, y, z, world);
        this.onBlockImpactEvent = hit -> {};
        this.onTickEvent = () -> {};
        this.withEffects = () -> new EffectInstance[0];
        this.ignorableBlocks = new ArrayList<Block>(Arrays.asList(Blocks.field_196800_gd, Blocks.field_150349_c, Blocks.field_196804_gh, Blocks.field_203198_aQ, Blocks.field_203214_jx, Blocks.field_203215_jy, Blocks.field_203199_aR, Blocks.field_150395_bd, Blocks.field_150488_af, Blocks.field_196555_aI, Blocks.field_196802_gf, (Block)ModBlocks.OPE.get()));
    }

    public AbilityProjectileEntity(EntityType type, World world, LivingEntity thrower) {
        this(type, world, thrower, (AbilityCore)null);
    }

    public AbilityProjectileEntity(EntityType type, World world, LivingEntity thrower, @Nullable Ability parent) {
        this(type, world, thrower, parent != null ? parent.getCore() : (AbilityCore)null);
    }

    public AbilityProjectileEntity(EntityType type, World world, LivingEntity thrower, @Nullable AbilityCore parent) {
        this(type, world, thrower, parent, parent != null ? parent.getSourceElement() : null, parent != null ? parent.getSourceHakiNature() : null, parent != null ? parent.getSourceTypes() : null);
    }

    public AbilityProjectileEntity(EntityType type, World world, LivingEntity thrower, @Nullable AbilityCore parent, SourceElement sourceElement, SourceHakiNature sourceHakiNature, ArrayList<SourceType> sourceTypes) {
        super(type, thrower, world);
        this.onBlockImpactEvent = hit -> {};
        this.onTickEvent = () -> {};
        this.withEffects = () -> new EffectInstance[0];
        this.ignorableBlocks = new ArrayList<Block>(Arrays.asList(Blocks.field_196800_gd, Blocks.field_150349_c, Blocks.field_196804_gh, Blocks.field_203198_aQ, Blocks.field_203214_jx, Blocks.field_203215_jy, Blocks.field_203199_aR, Blocks.field_150395_bd, Blocks.field_150488_af, Blocks.field_196555_aI, Blocks.field_196802_gf, (Block)ModBlocks.OPE.get()));
        this.maxLife = this.getLife();
        this.damage = 0.1f;
        this.setThrower(thrower);
        this.parent = parent;
        if (parent != null) {
            this.sourceElement = sourceElement;
            this.sourceHakiNature = sourceHakiNature;
            this.sourceTypes = sourceTypes;
            this.source = new AbilityDamageSource("ability_projectile", this, (AbilityCore<? extends IAbility>)parent).setSourceElement(this.sourceElement).setSourceTypes(this.sourceTypes).setHakiNature(this.sourceHakiNature).setProjectile();
        } else {
            this.source = new ModIndirectEntityDamageSource("ability_projectile", (Entity)this, (Entity)thrower).setProjectile();
        }
        this.bypassingSource = new ModIndirectEntityDamageSource("ability_projectile", (Entity)this, (Entity)thrower).setProjectile().setPiercing(1.0f);
    }

    public AbilityProjectileEntity(EntityType type, World world, LivingEntity thrower, SourceElement sourceElement, SourceHakiNature sourceHakiNature, SourceType ... sourceTypes) {
        super(type, thrower, world);
        this.onBlockImpactEvent = hit -> {};
        this.onTickEvent = () -> {};
        this.withEffects = () -> new EffectInstance[0];
        this.ignorableBlocks = new ArrayList<Block>(Arrays.asList(Blocks.field_196800_gd, Blocks.field_150349_c, Blocks.field_196804_gh, Blocks.field_203198_aQ, Blocks.field_203214_jx, Blocks.field_203215_jy, Blocks.field_203199_aR, Blocks.field_150395_bd, Blocks.field_150488_af, Blocks.field_196555_aI, Blocks.field_196802_gf, (Block)ModBlocks.OPE.get()));
        this.maxLife = this.getLife();
        this.damage = 0.1f;
        this.setThrower(thrower);
        this.sourceHakiNature = sourceHakiNature;
        this.sourceTypes = new ArrayList<SourceType>(Arrays.asList(sourceTypes));
        this.sourceElement = sourceElement;
        this.source = new ModIndirectEntityDamageSource("ability_projectile", (Entity)this, (Entity)thrower).setSourceElement(this.sourceElement).setSourceTypes(this.sourceTypes).setHakiNature(this.sourceHakiNature).setProjectile();
        this.bypassingSource = new ModIndirectEntityDamageSource("ability_projectile", (Entity)this, (Entity)thrower).setProjectile().setPiercing(1.0f);
    }

    private AxisAlignedBB getDefaultBoundingBox() {
        AxisAlignedBB def = super.func_174813_aQ();
        if (def != null) {
            return def;
        }
        return this.getDimensionsForge(Pose.STANDING).func_242286_a(this.func_213303_ch());
    }

    public AxisAlignedBB func_174813_aQ() {
        if (this.entityCollisionBox == null) {
            this.entityCollisionBox = this.getDefaultBoundingBox();
        }
        return new AxisAlignedBB(super.func_226277_ct_() - this.entityCollisionBox.func_216364_b() / 2.0, super.func_226278_cu_() - this.entityCollisionBox.func_216360_c() / 2.0, super.func_226281_cx_() - this.entityCollisionBox.func_216362_d() / 2.0, super.func_226277_ct_() + this.entityCollisionBox.func_216364_b() / 2.0, super.func_226278_cu_() + this.entityCollisionBox.func_216360_c() / 2.0, super.func_226281_cx_() + this.entityCollisionBox.func_216362_d() / 2.0);
    }

    public void func_234617_x_() {
        if (this.hasVelocityRotation) {
            super.func_234617_x_();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.tickDespawn();
            ProtectedArea area = ProtectedAreasData.get(this.field_70170_p).getProtectedArea((int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_());
            if (area != null && !area.canUseAbility(this.parent)) {
                this.func_70106_y();
                return;
            }
            if (!this.field_70170_p.isAreaLoaded(this.func_233580_cy_(), 1)) {
                this.func_70106_y();
                return;
            }
            this.checkEntityCollision();
            this.checkBlockCollision();
            if (this.field_70173_aa % this.getTargetResetTime() == 0) {
                this.clearTargets();
            }
        }
        this.onTickEvent.onTick();
    }

    private void checkEntityCollision() {
        Set parentEntities = this.field_70170_p.getPartEntities().stream().map(PartEntity::getParent).collect(Collectors.toSet());
        AxisAlignedBB boundingBox = this.getEntityCollisionBox();
        Vector3d velocity = super.func_213322_ci();
        Vector3d startPos = super.func_213303_ch();
        Vector3d endPos = startPos.func_178787_e(velocity);
        double stepSize = Math.max(boundingBox.func_216364_b(), Math.max(boundingBox.func_216360_c(), boundingBox.func_216362_d()));
        if (stepSize == 0.0) {
            return;
        }
        double steps = (velocity.func_72433_c() + 1.0) / stepSize;
        Vector3d stepDirection = velocity.func_72432_b().func_186678_a(stepSize);
        Vector3d currentPos = startPos;
        int i = 0;
        while ((double)i < steps) {
            Vector3d nextPos = currentPos.func_178787_e(stepDirection);
            if (Math.abs(currentPos.field_72450_a - nextPos.field_72450_a) > Math.abs(currentPos.field_72450_a - endPos.field_72450_a)) {
                nextPos = new Vector3d(endPos.field_72450_a, nextPos.field_72448_b, nextPos.field_72449_c);
            }
            if (Math.abs(currentPos.field_72448_b - nextPos.field_72448_b) > Math.abs(currentPos.field_72448_b - endPos.field_72448_b)) {
                nextPos = new Vector3d(nextPos.field_72450_a, endPos.field_72448_b, nextPos.field_72449_c);
            }
            if (Math.abs(currentPos.field_72449_c - nextPos.field_72449_c) > Math.abs(currentPos.field_72449_c - endPos.field_72449_c)) {
                nextPos = new Vector3d(nextPos.field_72450_a, nextPos.field_72448_b, endPos.field_72449_c);
            }
            Vector3d from = currentPos.func_178786_a(boundingBox.func_216364_b() / 2.0, boundingBox.func_216360_c() / 2.0, boundingBox.func_216362_d() / 2.0);
            Vector3d to = nextPos.func_72441_c(boundingBox.func_216364_b() / 2.0, boundingBox.func_216360_c() / 2.0, boundingBox.func_216362_d() / 2.0);
            if (this.firstEntityImpact || this.canPassThroughEntities) {
                AxisAlignedBB stepBoundingBox = new AxisAlignedBB(from, to);
                List entityList = this.field_70170_p.func_175647_a(Entity.class, stepBoundingBox, this.collisionPredicate);
                for (Entity target : entityList) {
                    if (parentEntities.contains(target)) continue;
                    this.onModHit((RayTraceResult)new EntityRayTraceResult(target));
                }
            }
            currentPos = nextPos;
            ++i;
        }
    }

    private void checkBlockCollision() {
        AxisAlignedBB boundingBox = this.getBlockCollisionBox();
        Vector3d velocity = super.func_213322_ci();
        Vector3d startPos = super.func_213303_ch();
        Vector3d endPos = startPos.func_178787_e(velocity);
        double stepSize = Math.max(boundingBox.func_216364_b(), Math.max(boundingBox.func_216360_c(), boundingBox.func_216362_d()));
        if (stepSize == 0.0) {
            return;
        }
        double steps = (velocity.func_72433_c() + 1.0) / stepSize;
        Vector3d stepDirection = velocity.func_72432_b().func_186678_a(stepSize);
        Vector3d currentPos = startPos;
        int i = 0;
        while ((double)i < steps) {
            Vector3d to;
            Vector3d from;
            BlockRayTraceResult result;
            Vector3d nextPos = currentPos.func_178787_e(stepDirection);
            if (Math.abs(currentPos.field_72450_a - nextPos.field_72450_a) > Math.abs(currentPos.field_72450_a - endPos.field_72450_a)) {
                nextPos = new Vector3d(endPos.field_72450_a, nextPos.field_72448_b, nextPos.field_72449_c);
            }
            if (Math.abs(currentPos.field_72448_b - nextPos.field_72448_b) > Math.abs(currentPos.field_72448_b - endPos.field_72448_b)) {
                nextPos = new Vector3d(nextPos.field_72450_a, endPos.field_72448_b, nextPos.field_72449_c);
            }
            if (Math.abs(currentPos.field_72449_c - nextPos.field_72449_c) > Math.abs(currentPos.field_72449_c - endPos.field_72449_c)) {
                nextPos = new Vector3d(nextPos.field_72450_a, nextPos.field_72448_b, endPos.field_72449_c);
            }
            if ((result = this.field_70170_p.func_217299_a(new RayTraceContext(from = currentPos.func_178786_a(boundingBox.func_216364_b() / 2.0, boundingBox.func_216360_c() / 2.0, boundingBox.func_216362_d() / 2.0), to = nextPos.func_72441_c(boundingBox.func_216364_b() / 2.0, boundingBox.func_216360_c() / 2.0, boundingBox.func_216362_d() / 2.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))).func_216346_c() == RayTraceResult.Type.BLOCK) {
                nextPos = result.func_216347_e();
                this.onModHit((RayTraceResult)result);
            }
            currentPos = nextPos;
            ++i;
        }
    }

    public void func_234612_a_(Entity thrower, float pX, float pY, float pZ, float velocity, float inaccuracy) {
        ProjectileShootEvent event = new ProjectileShootEvent(this, velocity, inaccuracy = Math.max(inaccuracy, 0.0f));
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        this.clearTargets();
        if (thrower instanceof MobEntity && ((MobEntity)thrower).func_70638_az() != null) {
            LivingEntity target = ((MobEntity)thrower).func_70638_az();
            float x = (float)(target.func_226277_ct_() - thrower.func_226277_ct_());
            float z = (float)(target.func_226281_cx_() - thrower.func_226281_cx_());
            float angle = (float)Math.toDegrees(Math.atan2(x, z));
            pY = -angle;
        }
        float f = -MathHelper.func_76126_a((float)(pY * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pX * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((pX + pZ) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(pY * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pX * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
    }

    public void shootFromRotation(float pX, float pY, float pZ, float velocity, float inaccuracy) {
        ProjectileShootEvent event = new ProjectileShootEvent(this, velocity, inaccuracy);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        this.clearTargets();
        float f = -MathHelper.func_76126_a((float)(pY * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pX * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((pX + pZ) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(pY * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pX * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci());
    }

    @Deprecated
    public void shoot(Entity thrower, float yRotIn, float xRotIn, float pitchOffset, float velocity, float inaccuracy) {
        this.func_234612_a_(thrower, yRotIn, xRotIn, pitchOffset, velocity, inaccuracy);
    }

    public boolean func_233566_aG_() {
        if (this.func_70090_H()) {
            this.func_71061_d_();
        }
        return false;
    }

    public void tickDespawn() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getLife() <= 0) {
                this.setLife(this.getMaxLife());
                this.func_70106_y();
                return;
            }
            this.setLife(this.getLife() - 1);
        }
    }

    public void onModHit(RayTraceResult hit) {
        if (!this.func_70089_S()) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        FluidState fluidState = null;
        if (hit.func_216346_c() == RayTraceResult.Type.ENTITY && this.canCollideWithEntities) {
            EntityRayTraceResult entityHit = (EntityRayTraceResult)hit;
            Entity owner = this.func_234616_v_();
            if (owner != null && owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                if (entityHit.func_216348_a() instanceof PartEntity) {
                    LivingEntity parent;
                    PartEntity hitEntity = (PartEntity)entityHit.func_216348_a();
                    if (hitEntity.getParent() == this.getThrower() && !this.canHurtThrower) {
                        return;
                    }
                    ProjectileHitEvent event = new ProjectileHitEvent(this, hit);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                    if (!this.entityDamaged && !this.targets.contains(hitEntity.getEntity().func_145782_y()) && hitEntity.getEntity().func_70089_S()) {
                        if (this.source == null) {
                            this.source = new ModIndirectEntityDamageSource("ability_projectile", (Entity)this, (Entity)livingOwner).setProjectile();
                        }
                        if (hitEntity.getParent() instanceof LivingEntity) {
                            parent = (LivingEntity)hitEntity.getParent();
                            if (!this.canBlockDamageSource(this.source, parent)) {
                                this.entityDamaged = this.armorPiercing > 0.0f ? hitEntity.func_70097_a((DamageSource)this.source, this.damage) : (this.damage == 0.0f && this.isFake ? true : hitEntity.func_70097_a((DamageSource)this.source, this.damage));
                            } else {
                                ItemStack stack = parent.func_184586_b(parent.func_184600_cs());
                                if (stack.func_77973_b() instanceof ShieldItem) {
                                    stack.func_222118_a((int)(this.getDamage() + 17.0f), parent, entity -> entity.func_213334_d(parent.func_184600_cs()));
                                }
                            }
                        }
                    }
                    if (this.entityDamaged) {
                        Vector3d v3d;
                        if (this.func_70027_ad()) {
                            hitEntity.func_70015_d(5);
                        }
                        if (hitEntity.getParent() instanceof LivingEntity) {
                            parent = (LivingEntity)hitEntity.getParent();
                            this.triggerEffects(parent);
                            this.onEntityImpactEvent.onImpact(parent);
                            this.firstEntityImpact = false;
                            if (this.changeHurtTime) {
                                IEntityStats entityStatsProps = EntityStatsCapability.get(parent);
                                entityStatsProps.setInvulnerableTime(this.hurtTime);
                                hitEntity.field_70172_ad = 0;
                            }
                        }
                        if (this.knockbackStrength > 0 && (v3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                            hitEntity.func_70024_g(v3d.field_72450_a, 0.1, v3d.field_72449_c);
                        }
                        if (!this.canPassThroughEntities) {
                            this.func_70106_y();
                            return;
                        }
                        this.targets.add(entityHit.func_216348_a().func_145782_y());
                        this.entityDamaged = false;
                    }
                } else if (entityHit.func_216348_a() instanceof LivingEntity) {
                    LivingEntity hitEntity = (LivingEntity)entityHit.func_216348_a();
                    if (hitEntity == this.getThrower() && !this.canHurtThrower) {
                        return;
                    }
                    ProjectileHitEvent event = new ProjectileHitEvent(this, hit);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                    if (this.damage < 0.0f) {
                        this.func_70106_y();
                        return;
                    }
                    if (!this.entityDamaged && !this.targets.contains(hitEntity.getEntity().func_145782_y()) && hitEntity.getEntity().func_70089_S()) {
                        if (this.source == null) {
                            this.source = new ModIndirectEntityDamageSource("ability_projectile", (Entity)this, (Entity)livingOwner).setProjectile();
                        }
                        if (!this.canBlockDamageSource(this.source, hitEntity)) {
                            float damage = (float)((double)this.damage * EntityStatsCapability.get(livingOwner).getDamageMultiplier());
                            this.entityDamaged = this.armorPiercing > 0.0f ? hitEntity.func_70097_a((DamageSource)this.source, damage) : (damage == 0.0f && this.isFake ? true : hitEntity.func_70097_a((DamageSource)this.source, damage));
                        } else {
                            ItemStack stack = hitEntity.func_184586_b(hitEntity.func_184600_cs());
                            if (stack.func_77973_b() instanceof ShieldItem) {
                                stack.func_222118_a((int)(this.getDamage() + 17.0f), hitEntity, entity -> entity.func_213334_d(hitEntity.func_184600_cs()));
                            }
                        }
                    }
                    if (this.entityDamaged) {
                        Vector3d v3d;
                        if (this.func_70027_ad()) {
                            hitEntity.func_70015_d(5);
                        }
                        this.triggerEffects(hitEntity);
                        this.onEntityImpactEvent.onImpact(hitEntity);
                        this.firstEntityImpact = false;
                        if (this.knockbackStrength > 0 && (v3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                            hitEntity.func_70024_g(v3d.field_72450_a, 0.1, v3d.field_72449_c);
                        }
                        if (this.changeHurtTime) {
                            IEntityStats entityStatsProps = EntityStatsCapability.get(hitEntity);
                            entityStatsProps.setInvulnerableTime(this.hurtTime);
                            hitEntity.field_70172_ad = 0;
                        }
                        if (!this.canPassThroughEntities) {
                            this.func_70106_y();
                            return;
                        }
                        this.targets.add(entityHit.func_216348_a().func_145782_y());
                        this.entityDamaged = false;
                    }
                }
            } else if (entityHit.func_216348_a() instanceof AbilityProjectileEntity) {
                AbilityProjectileEntity entity2 = (AbilityProjectileEntity)entityHit.func_216348_a();
                this.onProjectileCollision(this, entity2);
            }
        } else if (hit.func_216346_c() == RayTraceResult.Type.BLOCK && this.canCollideWithBlocks) {
            boolean isVanillaBarrier;
            if (this.hasBlockDestructionLimit && this.blocksAffected >= this.blocksAffectedLimit) {
                if (this.removeOnBlockLimit) {
                    this.func_70106_y();
                }
                return;
            }
            BlockRayTraceResult blockHit = (BlockRayTraceResult)hit;
            fluidState = this.field_70170_p.func_204610_c(blockHit.func_216350_a());
            if (fluidState != null && fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && this.getParent() != null && this.getParent().getCategory() == AbilityCategory.DEVIL_FRUITS) {
                this.func_70106_y();
                return;
            }
            ProjectileHitEvent event = new ProjectileHitEvent(this, hit);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            BlockState state = this.field_70170_p.func_180495_p(blockHit.func_216350_a());
            if (blockHit.func_216354_b() == null) {
                Direction ownerDirection = this.getThrower() != null && this.getThrower().func_70089_S() ? this.getThrower().func_174811_aO() : Direction.UP;
                blockHit = blockHit.func_216351_a(ownerDirection);
            }
            if (blockHit.func_216354_b() != null) {
                state.func_215690_a(this.field_70170_p, state, blockHit, (ProjectileEntity)this);
            }
            boolean bl = isVanillaBarrier = state.func_177230_c() == Blocks.field_180401_cv && !WyHelper.isInChallengeDimension(this.field_70170_p);
            if (!this.passedThroughIgnorableBlock(blockHit.func_216350_a())) {
                boolean passThroughBarrier;
                boolean isBariProj;
                boolean bl2 = isBariProj = state.func_177230_c() == ModBlocks.BARRIER.get() && this.func_200600_R() != BariProjectiles.BARRIERBILITY_STAIRS.get();
                if (isVanillaBarrier || isBariProj || state.func_177230_c().func_203417_a(ModTags.Blocks.KAIROSEKI)) {
                    this.onBlockImpactEvent.onImpact(blockHit.func_216350_a());
                    this.func_70106_y();
                    return;
                }
                boolean bl3 = passThroughBarrier = state.func_177230_c() == Blocks.field_180401_cv && WyHelper.isInChallengeDimension(this.field_70170_p);
                if (!passThroughBarrier && !this.canPassThroughBlocks) {
                    this.onBlockImpactEvent.onImpact(blockHit.func_216350_a());
                    boolean isAirBlock = this.field_70170_p.func_175623_d(blockHit.func_216350_a());
                    if (!isAirBlock) {
                        this.func_70106_y();
                    }
                }
                this.blocksAffected = (int)((float)this.blocksAffected + state.func_185887_b((IBlockReader)this.field_70170_p, blockHit.func_216350_a()));
            }
        }
        if (this.getThrower() != null) {
            boolean highlightCheck;
            boolean bl = highlightCheck = this.isAffectedByHaki() && HakiHelper.isProjectileHaoshokuInfused((ProjectileEntity)this);
            if (highlightCheck && (fluidState == null || fluidState.func_206888_e()) && this.lightningDischargeInterval.canTick()) {
                Color clientRGB = WyHelper.intToRGB(HakiHelper.getHaoshokuColour(this.getThrower()), 50);
                LightningDischargeEntity discharge = new LightningDischargeEntity((Entity)this, super.func_226277_ct_(), super.func_226278_cu_() + 1.5, super.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
                discharge.setAliveTicks(15);
                discharge.setLightningLength(6.0f);
                discharge.setColor(new Color(0, 0, 0, 100));
                discharge.setOutlineColor(clientRGB);
                discharge.setRenderTransparent();
                discharge.setDetails(4);
                discharge.setDensity(4);
                discharge.setSize(this.getDamage() / 10.0f);
                discharge.setSkipSegments(1);
                this.getThrower().field_70170_p.func_217376_c((Entity)discharge);
            }
        }
    }

    public void onProjectileCollision(AbilityProjectileEntity owner, AbilityProjectileEntity target) {
        boolean isDamageLarger;
        boolean isPhysical = owner.isPhysical();
        boolean isTargetPhysical = target.isPhysical();
        boolean bl = isDamageLarger = owner.getDamage() > target.getDamage();
        if (isPhysical) {
            if (isTargetPhysical) {
                if (isDamageLarger) {
                    target.func_70106_y();
                } else {
                    owner.func_70106_y();
                }
            } else {
                owner.func_70106_y();
            }
        } else if (isTargetPhysical) {
            target.func_70106_y();
        } else if (isDamageLarger) {
            target.func_70106_y();
        } else {
            owner.func_70106_y();
        }
    }

    public boolean func_241845_aY() {
        return false;
    }

    public void addBlockToIgnore(Block ... blocks) {
        for (Block block : blocks) {
            if (this.ignorableBlocks.contains(block)) continue;
            this.ignorableBlocks.add(block);
        }
    }

    public void triggerEffects(LivingEntity hitEntity) {
        if (this.withEffects.getEffects().length > 0) {
            for (EffectInstance instance : this.withEffects.getEffects()) {
                hitEntity.func_195064_c(instance);
            }
        }
    }

    public boolean canBlockDamageSource(DamageSource damageSource, LivingEntity target) {
        Vector3d Vector3d2;
        if (damageSource == null) {
            return false;
        }
        ProjectileBlockEvent event = new ProjectileBlockEvent(damageSource.func_76364_f());
        boolean flag = event.canBlock();
        if (!damageSource.func_76363_c() && target.func_184585_cz() && flag && (Vector3d2 = damageSource.func_188404_v()) != null) {
            Vector3d Vector3d3 = this.func_70040_Z();
            Vector3d Vector3d1 = Vector3d2.func_178788_d(new Vector3d(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_())).func_216371_e().func_72432_b();
            Vector3d1 = new Vector3d(Vector3d1.field_72450_a, 0.0, Vector3d1.field_72449_c);
            return Vector3d1.func_72430_b(Vector3d3) < 0.0;
        }
        return false;
    }

    public <T extends ModDamageSource> T getDamageSource() {
        return (T)((Object)this.source);
    }

    public void setDamageSource(ModDamageSource source) {
        this.source = source;
    }

    private boolean passedThroughIgnorableBlock(BlockPos pos) {
        FluidState fluidState = this.field_70170_p.func_204610_c(pos);
        if (!fluidState.func_206888_e()) {
            return true;
        }
        return this.ignorableBlocks.contains(this.field_70170_p.func_180495_p(pos).func_177230_c());
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setLife(compound.func_74762_e("life"));
        this.maxLife = compound.func_74762_e("maxLife");
        this.hurtTime = compound.func_74762_e("hurtTime");
        this.knockbackStrength = compound.func_74762_e("knockbackStrength");
        this.damage = compound.func_74760_g("damage");
        this.gravity = compound.func_74760_g("gravity");
        this.hasVelocityRotation = compound.func_74767_n("hasVelocityRotation");
        this.canPassThroughBlocks = compound.func_74767_n("canPassThroughBlocks");
        this.canPassThroughEntities = compound.func_74767_n("canPassThroughEntities");
        this.canGetStuckInGround = compound.func_74767_n("canGetStuckInGround");
        this.changeHurtTime = compound.func_74767_n("changeHurtTime");
        this.armorPiercing = compound.func_74760_g("armorPiercing");
        this.canHurtThrower = compound.func_74767_n("canHurtThrower");
        this.field_70180_af.func_187227_b(OWNER, (Object)compound.func_74762_e("ownerUUID"));
        this.sourceElement = SourceElement.values()[compound.func_74762_e("sourceElement")];
        this.sourceHakiNature = SourceHakiNature.values()[compound.func_74762_e("sourceHakiNature")];
        int[] sourceTypesOrdinal = compound.func_74759_k("sourceTypes");
        for (int i = 0; i < sourceTypesOrdinal.length; ++i) {
            SourceType sourceType = SourceType.values()[sourceTypesOrdinal[i]];
            if (this.sourceTypes.contains((Object)sourceType)) continue;
            this.sourceTypes.add(sourceType);
        }
        this.canCollideWithEntities = compound.func_74767_n("canCollideWithEntities");
        this.canCollideWithBlocks = compound.func_74767_n("canCollideWithBlocks");
        this.blocksAffectedLimit = compound.func_74762_e("blocksAffectedLimit");
        this.blocksAffected = compound.func_74762_e("blocksAffected");
        this.removeOnBlockLimit = compound.func_74767_n("removeOnBlockLimit");
        this.hasBlockDestructionLimit = compound.func_74767_n("hasBlockDestructionLimit");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("life", this.getLife());
        compound.func_74768_a("maxLife", this.maxLife);
        compound.func_74768_a("hurtTime", this.hurtTime);
        compound.func_74768_a("knockbackStrength", this.knockbackStrength);
        compound.func_74776_a("damage", this.damage);
        compound.func_74776_a("gravity", this.gravity);
        compound.func_74757_a("hasVelocityRotation", this.hasVelocityRotation);
        compound.func_74757_a("canPassThroughBlocks", this.canPassThroughBlocks);
        compound.func_74757_a("canPassThroughEntities", this.canPassThroughEntities);
        compound.func_74757_a("canGetStuckInGround", this.canGetStuckInGround);
        compound.func_74757_a("changeHurtTime", this.changeHurtTime);
        compound.func_74776_a("armorPiercing", this.armorPiercing);
        compound.func_74757_a("canHurtThrower", this.canHurtThrower);
        compound.func_74768_a("ownerUUID", ((Integer)this.field_70180_af.func_187225_a(OWNER)).intValue());
        compound.func_74768_a("sourceElement", this.sourceElement.ordinal());
        compound.func_74768_a("sourceHakiNature", this.sourceHakiNature.ordinal());
        compound.func_74783_a("sourceTypes", this.sourceTypes.stream().mapToInt(Enum::ordinal).toArray());
        compound.func_74757_a("canCollideWithEntities", this.canCollideWithEntities);
        compound.func_74757_a("canCollideWithBlocks", this.canCollideWithBlocks);
        compound.func_74768_a("blocksAffectedLimit", this.blocksAffectedLimit);
        compound.func_74768_a("blocksAffected", this.blocksAffected);
        compound.func_74757_a("removeOnBlockLimit", this.removeOnBlockLimit);
        compound.func_74757_a("hasBlockDestructionLimit", this.hasBlockDestructionLimit);
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void clearTargets() {
        this.targets.clear();
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(LIFE, (Object)64);
        this.field_70180_af.func_187214_a(OWNER, (Object)-1);
        this.field_70180_af.func_187214_a(IS_GLOWING, (Object)false);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeDouble(this.entityCollisionBox.func_216364_b());
        buffer.writeDouble(this.entityCollisionBox.func_216360_c());
        buffer.writeDouble(this.entityCollisionBox.func_216362_d());
        buffer.writeDouble(this.blockCollisionBox.func_216364_b());
        buffer.writeDouble(this.blockCollisionBox.func_216360_c());
        buffer.writeDouble(this.blockCollisionBox.func_216362_d());
        buffer.writeInt(this.maxLife);
        buffer.writeInt(this.func_234616_v_() != null ? this.func_234616_v_().func_145782_y() : -1);
        buffer.writeInt(this.sourceElement.ordinal());
        buffer.writeInt(this.sourceHakiNature.ordinal());
        buffer.writeInt(this.sourceTypes.size());
        for (SourceType sourceType : this.sourceTypes) {
            buffer.writeInt(sourceType.ordinal());
        }
        buffer.writeBoolean(this.hasVelocityRotation);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.setEntityCollisionSize(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.setBlockCollisionSize(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.maxLife = buffer.readInt();
        this.func_212361_a(this.field_70170_p.func_73045_a(buffer.readInt()));
        this.sourceElement = SourceElement.values()[buffer.readInt()];
        this.sourceHakiNature = SourceHakiNature.values()[buffer.readInt()];
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            SourceType sourceType = SourceType.values()[buffer.readInt()];
            if (this.sourceTypes.contains((Object)sourceType)) continue;
            this.sourceTypes.add(sourceType);
        }
        this.hasVelocityRotation = buffer.readBoolean();
    }

    public void setThrower(LivingEntity entity) {
        this.field_70180_af.func_187227_b(OWNER, (Object)entity.func_145782_y());
        this.func_212361_a((Entity)entity);
    }

    @Nullable
    public LivingEntity getThrower() {
        if (this.func_234616_v_() instanceof LivingEntity) {
            return (LivingEntity)this.func_234616_v_();
        }
        return null;
    }

    @Nullable
    public Entity func_234616_v_() {
        return this.func_184212_Q().func_187225_a(OWNER) != null && this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(OWNER)).intValue()) instanceof LivingEntity ? (LivingEntity)this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(OWNER)).intValue()) : super.func_234616_v_();
    }

    public void setKnockbackStrength(int knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }

    public void setGlowing() {
        this.field_70180_af.func_187227_b(IS_GLOWING, (Object)true);
    }

    public boolean func_225510_bt_() {
        return super.func_225510_bt_() || (Boolean)this.field_70180_af.func_187225_a(IS_GLOWING) != false;
    }

    public AxisAlignedBB getEntityCollisionBox() {
        return this.entityCollisionBox;
    }

    public void setEntityCollisionSize(double val) {
        this.setEntityCollisionSize(val, val, val);
    }

    public void setEntityCollisionSize(double x, double y, double z) {
        this.entityCollisionBox = new AxisAlignedBB(-x / 2.0, -y / 2.0, -z / 2.0, x / 2.0, y / 2.0, z / 2.0);
        if (!this.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateProjEntityCollisionBox(super.func_145782_y(), this.entityCollisionBox.func_216364_b(), this.entityCollisionBox.func_216360_c(), this.entityCollisionBox.func_216362_d()), (Entity)this.getThrower());
        }
    }

    public AxisAlignedBB getBlockCollisionBox() {
        return this.blockCollisionBox;
    }

    public void setBlockCollisionSize(double val) {
        this.setBlockCollisionSize(val, val, val);
    }

    public void setBlockCollisionSize(double x, double y, double z) {
        this.blockCollisionBox = new AxisAlignedBB(-x / 2.0, -y / 2.0, -z / 2.0, x / 2.0, y / 2.0, z / 2.0);
        if (!this.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateProjBlockCollisionBox(super.func_145782_y(), this.blockCollisionBox.func_216364_b(), this.blockCollisionBox.func_216360_c(), this.blockCollisionBox.func_216362_d()), (Entity)this.getThrower());
        }
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public int getMaxLife() {
        return this.maxLife;
    }

    public void setMaxLife(int life) {
        this.maxLife = life;
        this.setLife(this.maxLife);
    }

    public void setLife(int life) {
        this.field_70180_af.func_187227_b(LIFE, (Object)life);
    }

    public void setPhysical() {
        if (!this.sourceTypes.contains((Object)SourceType.PHYSICAL)) {
            this.sourceTypes.add(SourceType.PHYSICAL);
            this.sourceTypes.removeIf(sourceType -> sourceType == SourceType.UNKNOWN);
        }
    }

    public void setFist() {
        if (!this.sourceTypes.contains((Object)SourceType.FIST)) {
            this.sourceTypes.add(SourceType.FIST);
            this.sourceTypes.removeIf(sourceType -> sourceType == SourceType.UNKNOWN);
        }
    }

    public void setProjectile() {
        if (!this.sourceTypes.contains((Object)SourceType.PROJECTILE)) {
            this.sourceTypes.add(SourceType.PROJECTILE);
            this.sourceTypes.removeIf(sourceType -> sourceType == SourceType.UNKNOWN);
        }
    }

    public void setAffectedByImbuing() {
        this.setPhysical();
        this.sourceHakiNature = SourceHakiNature.IMBUING;
        if (this.source instanceof ModDamageSource) {
            this.source = this.source.setHakiNature(this.sourceHakiNature);
        }
    }

    public void setAffectedByHardening() {
        this.setPhysical();
        this.sourceHakiNature = SourceHakiNature.HARDENING;
        if (this.source instanceof ModDamageSource) {
            this.source = this.source.setHakiNature(this.sourceHakiNature);
        }
    }

    public void setHurtThrower() {
        this.canHurtThrower = true;
    }

    public boolean isPhysical() {
        if (this.source instanceof ModDamageSource) {
            return this.source.isPhysical();
        }
        return this.sourceTypes.contains((Object)SourceType.PHYSICAL);
    }

    public boolean isAffectedByHaki() {
        return this.isAffectedByHardening() || this.isAffectedByImbuing() || this.getSourceHakiNature() == SourceHakiNature.SPECIAL;
    }

    public boolean isAffectedByHardening() {
        return this.sourceHakiNature == SourceHakiNature.HARDENING || this.sourceHakiNature == SourceHakiNature.SPECIAL;
    }

    public boolean isAffectedByImbuing() {
        return this.sourceHakiNature == SourceHakiNature.IMBUING || this.sourceHakiNature == SourceHakiNature.SPECIAL;
    }

    public void setPassThroughBlocks() {
        this.canPassThroughBlocks = true;
    }

    public void setFake() {
        this.isFake = true;
    }

    public void setNoVelocityRotation() {
        this.hasVelocityRotation = false;
    }

    @Deprecated
    public void setArmorPiercing() {
        this.setArmorPiercing(1.0f);
    }

    public void setArmorPiercing(float piercing) {
        this.armorPiercing = piercing;
        if (this.source != null && this.source instanceof ModDamageSource) {
            this.source.setPiercing(piercing);
        }
    }

    public void setUnavoidable() {
        this.unavoidable = true;
        if (this.source != null && this.source instanceof ModDamageSource) {
            this.source.setUnavoidable();
        }
    }

    public float getArmorPiercing() {
        return this.armorPiercing;
    }

    public void setPassThroughEntities() {
        this.canPassThroughEntities = true;
    }

    @Deprecated
    public void setCanGetStuckInGround() {
        this.canGetStuckInGround = true;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public boolean isStuckInGround() {
        return this.stuckInGround;
    }

    public void setHurtTime(int time) {
        this.hurtTime = time;
        this.changeHurtTime = true;
    }

    public void setTargetResetTime(int time) {
        this.targetResetTime = time;
    }

    public int getTargetResetTime() {
        return this.targetResetTime;
    }

    public void setSourceHakiNature(SourceHakiNature kind) {
        this.sourceHakiNature = kind;
    }

    public SourceHakiNature getSourceHakiNature() {
        return this.sourceHakiNature;
    }

    public void setCollideWithEntities(boolean canCollideWithEntities) {
        this.canCollideWithEntities = canCollideWithEntities;
    }

    public void setCollideWithBlocks(boolean canCollideWithBlocks) {
        this.canCollideWithBlocks = canCollideWithBlocks;
    }

    public void setBlocksAffectedLimit(int limit) {
        this.blocksAffectedLimit = limit;
    }

    public int getBlocksAffectedLimit() {
        return this.blocksAffectedLimit;
    }

    public void increaseBlocksAffected(int increaseAmount) {
        this.blocksAffected = MathHelper.func_76125_a((int)(this.blocksAffected + increaseAmount), (int)0, (int)this.blocksAffectedLimit);
    }

    public int getBlocksAffected() {
        return this.blocksAffected;
    }

    public void setRemoveOnBlockLimit(boolean removeOnBlockLimit) {
        this.removeOnBlockLimit = removeOnBlockLimit;
    }

    public boolean getRemoveOnBlockLimit() {
        return this.removeOnBlockLimit;
    }

    public void setHasBlockDestructionLimit(boolean hasBlockDestructionLimit) {
        this.hasBlockDestructionLimit = hasBlockDestructionLimit;
    }

    public boolean getHasBlockDestructionLimit() {
        return this.hasBlockDestructionLimit;
    }

    public ExplosionAbility createExplosion(Entity entity, World world, double posX, double posY, double posZ, float size) {
        ExplosionAbility explosion = AbilityHelper.newExplosion(entity, world, posX, posY, posZ, size);
        explosion.onBlockDestroyedEvent = hitPos -> {
            int destroySpeed = Math.max((int)this.field_70170_p.func_180495_p(hitPos).getExplosionResistance((IBlockReader)this.field_70170_p, hitPos, (Explosion)explosion), 1);
            this.increaseBlocksAffected(destroySpeed);
            explosion.setExplodedBlocksLimit(this.getBlocksAffectedLimit() - this.getBlocksAffected());
        };
        return explosion;
    }

    @Nullable
    public AbilityCore<? extends Ability> getParent() {
        return this.parent;
    }

    public static interface IWithEffects
    extends Serializable {
        public EffectInstance[] getEffects();
    }

    public static interface IOnTick
    extends Serializable {
        public void onTick();
    }

    public static interface IOnBlockImpact
    extends Serializable {
        public void onImpact(BlockPos var1);
    }

    public static interface IOnEntityImpact
    extends Serializable {
        public void onImpact(LivingEntity var1);
    }
}

