/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.fishmankarate;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.fishmankarate.FishmanKarateProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.particles.effects.WaterExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MizuShuryudanProjectile
extends AbilityProjectileEntity {
    private Optional<LivingEntity> target;

    public MizuShuryudanProjectile(EntityType type, World world) {
        super(type, world);
    }

    public MizuShuryudanProjectile(World world, LivingEntity player) {
        super((EntityType)FishmanKarateProjectiles.MIZU_SHURYUDAN.get(), world, player, (AbilityCore)null);
        this.setDamage(7.0f);
        this.setMaxLife(400);
        this.setGravity(0.0f);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, hit.func_226277_ct_(), hit.func_226278_cu_(), hit.func_226281_cx_(), 3.0f);
        explosion.setExplosionSound(false);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(false);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles(new WaterExplosionParticleEffect());
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }

    public void setTarget(Optional<LivingEntity> target) {
        this.target = target;
    }

    private void onTickEvent() {
        if (this.target == null || !this.target.isPresent() || !ModEntityPredicates.IS_ALIVE_AND_SURVIVAL.test((Entity)this.target.get())) {
            List list = WyHelper.getNearbyLiving(this.func_213303_ch(), (IWorld)this.field_70170_p, 8.0, ModEntityPredicates.getEnemyFactions(this.getThrower()));
            list.remove(this.getThrower());
            list.sort(MobsHelper.ENTITY_THREAT);
            if (list.size() > 0) {
                this.target = list.stream().findAny();
            }
            if (this.field_70173_aa % 5 == 0) {
                AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci().func_186678_a(0.7));
            }
        } else {
            Vector3d dist = this.func_213303_ch().func_178788_d(this.target.get().func_213303_ch().func_72441_c(0.0, 1.0, 0.0)).func_72432_b().func_216372_d(0.4, 1.0, 0.4);
            AbilityHelper.setDeltaMovement((Entity)this, -dist.field_72450_a, -dist.field_72448_b, -dist.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197630_w, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

