/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.goro;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.IFlexibleSizeProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.GoroProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class VariProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(VariProjectile.class, (IDataSerializer)DataSerializers.field_187193_c);
    private ExplosionAbility explosion;

    public VariProjectile(EntityType type, World world) {
        super(type, world);
    }

    public VariProjectile(World world, double x, double y, double z) {
        super((EntityType)GoroProjectiles.VOLT_VARI.get(), world, x, y, z);
    }

    public VariProjectile(World world, LivingEntity player, float power, Ability ability) {
        super((EntityType)GoroProjectiles.VOLT_VARI.get(), world, player, ability.getCore());
        this.setMaxLife(40);
        this.setPassThroughEntities();
        this.onTickEvent = this::onTickEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, 0.0, 0.0, 0.0, 0.0f);
        this.explosion.setStaticDamage(5.0f + power / 10.0f);
        this.explosion.setExplosionSound(true);
        this.explosion.setDamageOwner(false);
        this.explosion.setDestroyBlocks(true);
        this.explosion.setStaticBlockResistance(0.1f);
        this.explosion.setDamageEntities(true);
    }

    private void onBlockImpactEvent(BlockPos hit) {
        float voltage = ((Float)this.func_184212_Q().func_187225_a(SIZE)).floatValue();
        if (voltage > 2.0f) {
            this.explosion.setExplosionPos(hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p());
            this.explosion.doExplosion();
        }
    }

    private void onTickEvent() {
        float voltage = ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                ParticleType particleToUse = this.field_70173_aa % 2 == 0 ? (ParticleType)ModParticleTypes.GORO2_YELLOW.get() : (ParticleType)ModParticleTypes.GORO_YELLOW.get();
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                SimpleParticleData data = new SimpleParticleData(particleToUse);
                data.setLife(8);
                data.setSize(4.0f * voltage / 100.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void setSize(float size) {
        this.setDamage(10.0f + size * 2.0f);
        this.func_174826_a(this.func_174813_aQ().func_186662_g((double)(size / 100.0f)));
        this.func_184212_Q().func_187227_b(SIZE, (Object)Float.valueOf(Math.min(size, 100.0f)));
        float power = ((Float)this.func_184212_Q().func_187225_a(SIZE)).floatValue() / 20.0f;
        this.explosion.setExplosionSize(power * 2.0f);
        this.explosion.setExplodedBlocksLimit((int)(power * 150.0f));
        this.explosion.setSmokeParticles(new CommonExplosionParticleEffect((int)(power * 0.9f)));
    }

    @Override
    public float getSize() {
        return 0.7f + ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue() / 10.0f;
    }
}

