/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hie;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.HieProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class IceBallProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE).build();
    private static final BlockProtectionRule GRIEF_RULE_BLUE_ICE = new BlockProtectionRule.Builder(new BlockProtectionRule[0]).addApprovedBlocks(Blocks.field_205164_gk).build();

    public IceBallProjectile(EntityType type, World world) {
        super(type, world);
    }

    public IceBallProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)HieProjectiles.ICE_BALL.get(), world, player, ability);
        this.setDamage(25.0f);
        this.setMaxLife(32);
        super.setPhysical();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(Effects.field_76421_d, 100, 0), new EffectInstance(Effects.field_76419_f, 100, 0)};
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        AbilityHelper.addFrostbiteStacks(entity, super.getThrower(), 6);
        if (!AbilityHelper.createSphere(this.field_70170_p, entity.func_233580_cy_(), 6, false, Blocks.field_205164_gk, 2, GRIEF_RULE).isEmpty()) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    AbilityHelper.placeBlockIfAllowed(this.getThrower(), entity.func_233580_cy_().func_177963_a((double)i, (double)entity.func_70047_e(), (double)j), Blocks.field_150350_a.func_176223_P(), GRIEF_RULE_BLUE_ICE);
                }
            }
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.createSphere(this.field_70170_p, hit, 6, false, Blocks.field_205164_gk, 2, GRIEF_RULE);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = WyHelper.randomDouble() / 1.5;
                double offsetY = WyHelper.randomDouble() / 1.5;
                double offsetZ = WyHelper.randomDouble() / 1.5;
                SimpleParticleData part = new SimpleParticleData((ParticleType)ModParticleTypes.HIE.get());
                part.setLife(14);
                part.setAnimationSpeed(2);
                part.setRotation(Vector3f.field_229183_f_);
                part.setRotationSpeed(i % 2 == 0 ? 0.07f : -0.07f);
                part.setSize(1.5f);
                WyHelper.spawnParticles(part, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

