/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.ope;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.ope.RoomAbility;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModIndirectEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ope.OpeProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SpatialSlashProjectile
extends AbilityProjectileEntity {
    public SpatialSlashProjectile(EntityType type, World world) {
        super(type, world);
    }

    public SpatialSlashProjectile(World world, LivingEntity player) {
        super((EntityType)OpeProjectiles.SPATIAL_SLASH.get(), world, player);
        this.setDamageSource(new ModIndirectEntityDamageSource("ability_projectile", (Entity)this, null).setProjectile());
        this.setDamage(5.0f);
        this.setPhysical();
        this.setMaxLife(20);
        this.setCanGetStuckInGround();
        this.onBlockImpactEvent = this::onBlockImpact;
        this.onEntityImpactEvent = this::onEntityImpact;
    }

    private void onEntityImpact(LivingEntity entity) {
        boolean hakiCondition = (double)HakiDataCapability.get(entity).getBusoshokuHakiExp() + WyHelper.randomWithRange(0, 5) >= (double)HakiDataCapability.get(this.getThrower()).getBusoshokuHakiExp();
        boolean specialCondition = DevilFruitCapability.get(entity).isLogia() && !HakiHelper.hasHardeningActive(entity);
        boolean hpCondition = this.getThrower().func_110143_aJ() >= entity.func_110143_aJ() + 10.0f;
        boolean blocking = AbilityHelper.isTargetBlocking(this.getThrower(), entity);
        if (!(hakiCondition || specialCondition || hpCondition || blocking)) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 200, 0, false, false));
        }
    }

    private void onBlockImpact(BlockPos blockPos) {
        this.field_70170_p.func_217377_a(blockPos, true);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getThrower() != null && this.field_70173_aa > 0 && this.getThrower().field_70173_aa > 0) {
            RoomAbility a = AbilityDataCapability.get(this.getThrower()).getEquippedAbility(RoomAbility.INSTANCE);
            if (a == null) {
                this.func_70106_y();
            }
            if (!a.isPositionInRoom(this.func_233580_cy_())) {
                this.func_70106_y();
            }
        }
    }
}

