/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.pika;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.pika.AmaterasuAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.pika.PikaProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AmaterasuProjectile
extends AbilityProjectileEntity {
    public AmaterasuProjectile(EntityType type, World world) {
        super(type, world);
    }

    public AmaterasuProjectile(World world, LivingEntity player) {
        super((EntityType)PikaProjectiles.AMATERASU.get(), world, player, AmaterasuAbility.INSTANCE);
        this.setDamage(70.0f);
        this.setArmorPiercing(1.0f);
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), this.getDamage() / 4.0f);
        explosion.setStaticDamage(this.getDamage() * 0.75f);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect((int)(this.getDamage() / 6.0f)));
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.PIKA.get());
            data.setLife(40);
            data.setSize(10.0f);
            data.setRotation(Vector3f.field_229181_d_);
            WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }
}

