/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.suna;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.suna.BarjanAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.SunaProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BarjanProjectile
extends AbilityProjectileEntity {
    public BarjanProjectile(EntityType type, World world) {
        super(type, world);
    }

    public BarjanProjectile(World world, LivingEntity player) {
        super((EntityType)SunaProjectiles.BARJAN.get(), world, player, BarjanAbility.INSTANCE);
        this.setDamage(30.0f);
        this.setMaxLife(15);
        this.setCanGetStuckInGround();
        this.setPassThroughEntities();
        this.setEntityCollisionSize(1.0, 0.2f, 1.0);
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(Effects.field_82731_v, 100, 3, false, false), new EffectInstance((Effect)ModEffects.DEHYDRATION.get(), 200, 2, false, true), new EffectInstance(Effects.field_76437_t, 150, 0, false, false), new EffectInstance(Effects.field_76421_d, 150, 0, false, false), new EffectInstance(Effects.field_76419_f, 150, 0, false, false)};
        this.onEntityImpactEvent = this::onEntityImpact;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpact(LivingEntity entity) {
    }

    private void onTickEvent() {
        for (int i = 0; i < 5; ++i) {
            double offsetX = WyHelper.randomDouble();
            double offsetY = WyHelper.randomDouble() / 4.0;
            double offsetZ = WyHelper.randomDouble();
            SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.SUNA2.get());
            data.setLife(4);
            data.setSize(1.4f);
            WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
        }
    }
}

