/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.yami;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yami.YamiProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlackRoadProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(CoreBlockProtectionRule.INSTANCE).build();

    public BlackRoadProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public BlackRoadProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)YamiProjectiles.BLACK_ROAD.get(), world, player, ability.getCore());
        this.setMaxLife(20);
        this.setDamage(10.0f);
        this.setPassThroughEntities();
        this.setPassThroughBlocks();
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177979_c(j));
            if (state.func_185904_a().func_76220_a()) {
                pos = this.func_233580_cy_().func_177979_c(j);
                break;
            }
            if (j > 2) break;
            ++j;
        }
        if (pos == null) {
            return;
        }
        int size = Math.round(2.0f + 4.0f * (1.0f - (float)this.getLife() / (float)this.getMaxLife()));
        AbilityHelper.createFilledSphere(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), size, (Block)ModBlocks.DARKNESS.get(), GRIEF_RULE);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DARK_MATTER_CHARGING.get(), (Entity)this, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }
}

