/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.yuki;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yuki.YukiProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class YukiRabiProjectile
extends AbilityProjectileEntity {
    public YukiRabiProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public YukiRabiProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)YukiProjectiles.YUKI_RABI.get(), world, player, ability.getCore());
        this.setDamage(3.5f);
        this.addBlockToIgnore(Blocks.field_150433_aE, Blocks.field_196604_cC, (Block)ModBlocks.HARDENED_SNOW.get());
        this.onTickEvent = this::onTickEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        AbilityHelper.addFrostbiteStacks(entity, this.getThrower(), 1);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 5.0;
                double offsetY = WyHelper.randomDouble() / 5.0;
                double offsetZ = WyHelper.randomDouble() / 5.0;
                ParticleType particle = i % 2 == 0 ? (ParticleType)ModParticleTypes.YUKI2.get() : (ParticleType)ModParticleTypes.YUKI.get();
                SimpleParticleData data = new SimpleParticleData(particle);
                data.setLife(20);
                data.setSize(1.3f);
                data.setMotion(0.0, -0.02, 0.0);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 0.25 + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

