/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.CannonEntity;
import xyz.pixelatedw.mineminenomi.entities.StrikerEntity;
import xyz.pixelatedw.mineminenomi.entities.UnicycleEntity;
import xyz.pixelatedw.mineminenomi.events.EffectsEvents;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.packets.server.SToggleAnimationPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class EntityEvents {
    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        IEntityStats entityProps = EntityStatsCapability.get(entity);
        entity.field_70702_br = entityProps.getLeftImpulse();
        entity.field_191988_bg = entityProps.getForwardImpulse();
        EffectsEvents.Common.launchedCollision(entity);
    }

    @SubscribeEvent
    public static void onMountEffects(EntityMountEvent event) {
        if (!event.getWorldObj().field_72995_K && event.getEntityMounting() instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)event.getEntityMounting();
            if (event.isMounting()) {
                if (event.getEntityBeingMounted() instanceof StrikerEntity) {
                    WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.playAnimation(living, ModAnimations.RIDE_STRIKER, -1, true), (Entity)living);
                } else if (event.getEntityBeingMounted() instanceof CannonEntity) {
                    WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.playAnimation(living, ModAnimations.CANNON_HANDLING, -1, true), (Entity)living);
                } else if (event.getEntityBeingMounted() instanceof UnicycleEntity) {
                    WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.playAnimation(living, ModAnimations.RIDE_UNICYCLE, -1, true), (Entity)living);
                }
            } else if (event.getEntityBeingMounted() instanceof StrikerEntity) {
                WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.stopAnimation(living, ModAnimations.RIDE_STRIKER), (Entity)living);
            } else if (event.getEntityBeingMounted() instanceof CannonEntity) {
                WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.stopAnimation(living, ModAnimations.CANNON_HANDLING), (Entity)living);
            } else if (event.getEntityBeingMounted() instanceof UnicycleEntity) {
                WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.stopAnimation(living, ModAnimations.RIDE_UNICYCLE), (Entity)living);
            }
        }
    }
}

