/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.entities.IGoalMemoriesEntity;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.LapahnEntity;
import xyz.pixelatedw.mineminenomi.init.ModMemoryModuleTypes;
import xyz.pixelatedw.mineminenomi.mixins.IExplosionMixin;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class EntityGoalEvents {
    private static final int LAST_EXPLOSION_TICKS = 6000;
    private static final TargetsPredicate RABBIT_HELP_CALL_PREDICATE = new TargetsPredicate().selector(entity -> entity instanceof LapahnEntity);

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!event.getWorld().field_72995_K && entity instanceof IronGolemEntity) {
            IronGolemEntity golem = (IronGolemEntity)entity;
            golem.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)golem, MobEntity.class, 5, false, false, target -> target instanceof OPEntity && (((OPEntity)target).getEntityStats().isBandit() || ((OPEntity)target).getEntityStats().isPirate())));
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonates(ExplosionEvent.Detonate event) {
        BlockPos pos = new BlockPos(event.getExplosion().getPosition());
        float radius = ((IExplosionMixin)event.getExplosion()).getRadius() * 8.0f;
        List<LivingEntity> targets = WyHelper.getNearbyEntities(event.getExplosion().getPosition(), (IWorld)event.getWorld(), (double)radius, radius, radius, null, LivingEntity.class);
        for (LivingEntity target : targets) {
            if (!(target instanceof IGoalMemoriesEntity)) continue;
            ((IGoalMemoriesEntity)target).setMemoryWithExpiry((MemoryModuleType)ModMemoryModuleTypes.LAST_EXPLOSION_HEARD.get(), GlobalPos.func_239648_a_((RegistryKey)event.getWorld().func_234923_W_(), (BlockPos)pos), 6000L);
        }
    }

    @SubscribeEvent
    public static void onHurtEntity(LivingHurtEvent event) {
        LivingEntity attacker = null;
        Entity directAttacker = event.getSource().func_76364_f();
        if (directAttacker instanceof LivingEntity) {
            attacker = (LivingEntity)directAttacker;
        }
        if (event.getEntityLiving() instanceof RabbitEntity) {
            List<LapahnEntity> lapahns = TargetHelper.getEntitiesInArea(event.getEntityLiving(), 10.0, RABBIT_HELP_CALL_PREDICATE, LapahnEntity.class);
            for (LapahnEntity lapahn : lapahns) {
                if (!lapahn.func_70089_S() || lapahn.func_70638_az() != null && lapahn.func_70638_az().func_70089_S()) continue;
                lapahn.func_70624_b(attacker);
            }
        }
    }
}

