/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.events.stats.DorikiEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.entity.kairosekicoating.KairosekiCoatingCapability;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityProgressionEvents;
import xyz.pixelatedw.mineminenomi.packets.server.SSetServerMaxBarsPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SRecalculateEyeHeightPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SSetHakiColorPacket;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SKairosekiCoatingPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class SyncEvents {
    @SubscribeEvent
    public static void onDorikiGained(DorikiEvent.Post event) {
        AttributeHelper.updateHPAttribute(event.getPlayer());
        AttributeHelper.updateToughnessAttribute((LivingEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void onEntityJoins(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            if (event.getEntity() instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
                AbilityProgressionEvents.forceAdvancementChecks(player);
                player.func_184102_h().func_195571_aL().func_197051_a(player);
                WyNetwork.sendTo(new SSetServerMaxBarsPacket(CommonConfig.INSTANCE.getAbilityBars()), (PlayerEntity)player);
            }
            AttributeHelper.updateHPAttribute((PlayerEntity)event.getEntity());
            AttributeHelper.updateToughnessAttribute((LivingEntity)((PlayerEntity)event.getEntity()));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (player.field_70173_aa < 5 && !player.field_70170_p.field_72995_K) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SUpdateHealthPacket(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
        IHakiData hakiDataProps = HakiDataCapability.get((LivingEntity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncEntityStatsPacket(player.func_145782_y(), entityStatsProps), (Entity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), (Entity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncAbilityDataPacket(player.func_145782_y(), abilityDataProps), (Entity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncEntityStatsPacket(player.func_145782_y(), entityProps), (Entity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncHakiDataPacket(player.func_145782_y(), hakiDataProps), (Entity)player);
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.Size((Entity)player, player.func_213283_Z(), player.func_213305_a(player.func_213283_Z()), player.func_213302_cg()));
        WyNetwork.sendToAllTrackingAndSelf(new SRecalculateEyeHeightPacket(player.func_145782_y()), (Entity)player);
    }

    @SubscribeEvent
    public static void onPlayerStartsTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)event.getTarget();
            IEntityStats entityStatsProps = EntityStatsCapability.get(target);
            IDevilFruit devilFruitProps = DevilFruitCapability.get(target);
            IAbilityData abilityDataProps = AbilityDataCapability.get(target);
            IHakiData hakiDataProps = HakiDataCapability.get(target);
            WyNetwork.sendTo(new SSyncEntityStatsPacket(target.func_145782_y(), entityStatsProps), event.getPlayer());
            WyNetwork.sendTo(new SSyncDevilFruitPacket(target.func_145782_y(), devilFruitProps), event.getPlayer());
            WyNetwork.sendTo(new SSyncAbilityDataPacket(target.func_145782_y(), abilityDataProps), event.getPlayer());
            WyNetwork.sendTo(new SSyncHakiDataPacket(target.func_145782_y(), hakiDataProps), event.getPlayer());
            WyNetwork.sendTo(new SSetHakiColorPacket(event.getPlayer().func_145782_y()), event.getPlayer());
        }
        if (event.getTarget() instanceof BoatEntity) {
            int coatingLevel;
            BoatEntity boat = (BoatEntity)event.getTarget();
            if (!boat.field_70170_p.field_72995_K && (coatingLevel = KairosekiCoatingCapability.get((Entity)boat).map(props -> props.getCoatingLevel()).orElse(0).intValue()) > 0) {
                WyNetwork.sendTo(new SKairosekiCoatingPacket(boat.func_145782_y(), coatingLevel), event.getPlayer());
            }
        }
    }
}

