/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.ILocalLightningBoltEntity;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.util.TPSDelta;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;
import xyz.pixelatedw.mineminenomi.data.world.EventsWorldData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.data.world.NPCWorldData;
import xyz.pixelatedw.mineminenomi.init.ModBiomes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.world.spawners.AmbushSpawner;
import xyz.pixelatedw.mineminenomi.world.spawners.TraderSpawner;
import xyz.pixelatedw.mineminenomi.world.spawners.TrainerSpawner;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class WorldEvents {
    private static final TraderSpawner TRADER_SPAWNER = new TraderSpawner();
    private static final TrainerSpawner TRAINER_SPAWNER = new TrainerSpawner();
    private static final AmbushSpawner AMBUSH_SPAWNER = new AmbushSpawner();
    private static final Predicate<ServerPlayerEntity> THUNDER_PLAINS_BIOME_CHECK = player -> {
        ResourceLocation biome = player.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)player.field_70170_p.func_226691_t_(player.func_233580_cy_()));
        return biome.equals((Object)ModBiomes.RAIGO.getId()) && player.field_70170_p.func_226660_f_(player.func_233580_cy_());
    };

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TPSDelta.INSTANCE.tick();
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TPSDelta.INSTANCE.tick();
            if (event.world.func_234923_W_() == World.field_234918_g_) {
                if (event.world.func_82737_E() % 20L == 0L) {
                    event.world.func_217381_Z().func_76320_a("crews");
                    ExtendedWorldData.get().getCrews().forEach(Crew::tick);
                    event.world.func_217381_Z().func_76319_b();
                    event.world.func_217381_Z().func_76320_a("worldEvents");
                    EventsWorldData.get().tick((ServerWorld)event.world);
                    event.world.func_217381_Z().func_76319_b();
                    event.world.func_217381_Z().func_76320_a("trackedNPCs");
                    NPCWorldData.get().tick((ServerWorld)event.world);
                    event.world.func_217381_Z().func_76319_b();
                }
                if (event.world.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
                    event.world.func_217381_Z().func_76320_a("worldSpawners");
                    if (CommonConfig.INSTANCE.canSpawnTraders()) {
                        TRADER_SPAWNER.tick((ServerWorld)event.world);
                    }
                    if (CommonConfig.INSTANCE.canSpawnTrainers()) {
                        TRAINER_SPAWNER.tick((ServerWorld)event.world);
                    }
                    if (CommonConfig.INSTANCE.canSpawnAmbushes()) {
                        AMBUSH_SPAWNER.tick((ServerWorld)event.world);
                    }
                    event.world.func_217381_Z().func_76319_b();
                }
                WorldEvents.thunderPlains((ServerWorld)event.world);
            } else if (event.world.func_234923_W_().func_240901_a_().toString().contains("challenges_")) {
                event.world.func_217381_Z().func_76320_a("challengesManager");
                ChallengesWorldData.get().tick((ServerWorld)event.world);
                event.world.func_217381_Z().func_76319_b();
            }
        }
    }

    public static final void spawnOPChunkEntities(IServerWorld world, Biome biome, int chunkX, int chunkZ, Random rand) {
        WorldEvents.spawnMobsForChunkGeneration(world, biome, chunkX, chunkZ, rand, ModEntities.MARINES);
        WorldEvents.spawnMobsForChunkGeneration(world, biome, chunkX, chunkZ, rand, ModEntities.PIRATES);
        WorldEvents.spawnMobsForChunkGeneration(world, biome, chunkX, chunkZ, rand, ModEntities.BANDITS);
    }

    private static final void thunderPlains(ServerWorld world) {
        if (world.func_82737_E() % (long)(20 + world.func_201674_k().nextInt(10)) != 0L) {
            return;
        }
        int limit = MathHelper.func_76125_a((int)(world.func_217369_A().size() / 3), (int)1, (int)10);
        world.func_217369_A().stream().filter(THUNDER_PLAINS_BIOME_CHECK).limit(limit).forEach(player -> {
            if (player.func_226278_cu_() > 128.0) {
                return;
            }
            int strikes = 2 + world.func_201674_k().nextInt(5);
            for (int i = 0; i < strikes; ++i) {
                ResourceLocation biome;
                boolean strikePlayer;
                int x = (int)((double)(player.func_70681_au().nextInt(151) - 50) + player.func_226277_ct_());
                int z = (int)((double)(player.func_70681_au().nextInt(151) - 50) + player.func_226281_cx_());
                int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z);
                BlockPos strikePos = new BlockPos(x, y, z);
                boolean bl = strikePlayer = world.func_201674_k().nextInt(512) == 0;
                if (strikePlayer) {
                    strikePos = player.func_233580_cy_();
                }
                if (!(biome = player.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)player.field_70170_p.func_226691_t_(strikePos))).equals((Object)ModBiomes.RAIGO.getId())) continue;
                LightningBoltEntity bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((World)world);
                ((ILocalLightningBoltEntity)bolt).setLocal();
                bolt.func_174828_a(strikePos, 0.0f, 0.0f);
                world.func_217376_c((Entity)bolt);
            }
        });
    }

    private static void spawnMobsForChunkGeneration(IServerWorld world, Biome biome, int chunkX, int chunkZ, Random rand, EntityClassification category) {
        MobSpawnInfo mobspawninfo = biome.func_242433_b();
        List list = mobspawninfo.func_242559_a(category);
        if (!list.isEmpty()) {
            int x = chunkX << 4;
            int z = chunkZ << 4;
            while (rand.nextFloat() < mobspawninfo.func_242557_a()) {
                MobSpawnInfo.Spawners spawners = (MobSpawnInfo.Spawners)WeightedRandom.func_76271_a((Random)rand, (List)list);
                int k = spawners.field_242589_d + rand.nextInt(1 + spawners.field_242590_e - spawners.field_242589_d);
                ILivingEntityData ilivingentitydata = null;
                int l = x + rand.nextInt(16);
                int i1 = z + rand.nextInt(16);
                int j1 = l;
                int k1 = i1;
                for (int l1 = 0; l1 < k; ++l1) {
                    boolean flag = false;
                    for (int i2 = 0; !flag && i2 < 4; ++i2) {
                        BlockPos blockpos = WorldEvents.getTopNonCollidingPos((IWorldReader)world, spawners.field_242588_c, l, i1);
                        if (spawners.field_242588_c.func_200720_b() && WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.func_209344_a((EntityType)spawners.field_242588_c), (IWorldReader)world, (BlockPos)blockpos, (EntityType)spawners.field_242588_c)) {
                            Entity entity;
                            float f = spawners.field_242588_c.func_220333_h();
                            double d0 = MathHelper.func_151237_a((double)l, (double)((double)x + (double)f), (double)((double)x + 16.0 - (double)f));
                            double d1 = MathHelper.func_151237_a((double)i1, (double)((double)z + (double)f), (double)((double)z + 16.0 - (double)f));
                            if (!world.func_226664_a_(spawners.field_242588_c.func_220328_a(d0, (double)blockpos.func_177956_o(), d1)) || !EntitySpawnPlacementRegistry.func_223515_a((EntityType)spawners.field_242588_c, (IServerWorld)world, (SpawnReason)SpawnReason.CHUNK_GENERATION, (BlockPos)new BlockPos(d0, (double)blockpos.func_177956_o(), d1), (Random)world.func_201674_k())) continue;
                            try {
                                entity = spawners.field_242588_c.func_200721_a((World)world.func_201672_e());
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            entity.func_70012_b(d0, (double)blockpos.func_177956_o(), d1, rand.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof MobEntity) {
                                MobEntity mobentity = (MobEntity)entity;
                                if (ForgeHooks.canEntitySpawn((MobEntity)mobentity, (IWorld)world, (double)d0, (double)blockpos.func_177956_o(), (double)d1, null, (SpawnReason)SpawnReason.CHUNK_GENERATION) == -1) continue;
                                if (mobentity.func_213380_a((IWorld)world, SpawnReason.CHUNK_GENERATION) && mobentity.func_205019_a((IWorldReader)world)) {
                                    ilivingentitydata = mobentity.func_213386_a(world, world.func_175649_E(mobentity.func_233580_cy_()), SpawnReason.CHUNK_GENERATION, ilivingentitydata, (CompoundNBT)null);
                                    world.func_242417_l((Entity)mobentity);
                                    flag = true;
                                }
                            }
                        }
                        l += rand.nextInt(5) - rand.nextInt(5);
                        i1 += rand.nextInt(5) - rand.nextInt(5);
                        while (l < x || l >= x + 16 || i1 < z || i1 >= z + 16) {
                            l = j1 + rand.nextInt(5) - rand.nextInt(5);
                            i1 = k1 + rand.nextInt(5) - rand.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPos getTopNonCollidingPos(IWorldReader level, EntityType<?> entityType, int pX, int pZ) {
        BlockPos blockpos;
        int i = level.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(entityType), pX, pZ);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(pX, i, pZ);
        if (level.func_230315_m_().func_236037_d_()) {
            do {
                blockpos$mutable.func_189536_c(Direction.DOWN);
            } while (!level.func_180495_p((BlockPos)blockpos$mutable).func_196958_f());
            do {
                blockpos$mutable.func_189536_c(Direction.DOWN);
            } while (level.func_180495_p((BlockPos)blockpos$mutable).func_196958_f() && blockpos$mutable.func_177956_o() > 0);
        }
        if (EntitySpawnPlacementRegistry.func_209344_a(entityType) == EntitySpawnPlacementRegistry.PlacementType.ON_GROUND && level.func_180495_p(blockpos = blockpos$mutable.func_177977_b()).func_196957_g((IBlockReader)level, blockpos, PathType.LAND)) {
            return blockpos;
        }
        return blockpos$mutable.func_185334_h();
    }
}

