/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.abilities;

import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCoreUnlockWrapper;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.events.SetPlayerDetailsEvent;
import xyz.pixelatedw.mineminenomi.api.events.ability.UnlockAbilityEvent;
import xyz.pixelatedw.mineminenomi.api.events.stats.DorikiEvent;
import xyz.pixelatedw.mineminenomi.api.events.stats.HakiExpEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityValidationEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.items.armors.CaptainCapeItem;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class AbilityProgressionEvents {
    @SubscribeEvent
    public static void onHakiExpGained(HakiExpEvent.Post event) {
        AbilityProgressionEvents.checkForHakiUnlocks(event.getPlayer());
    }

    @SubscribeEvent
    public static void onDorikiGained(DorikiEvent.Post event) {
        AbilityProgressionEvents.checkForRacialUnlocks(event.getPlayer());
        AbilityProgressionEvents.checkForHakiUnlocks(event.getPlayer());
    }

    @SubscribeEvent
    public static void onStatsSet(SetPlayerDetailsEvent event) {
        AbilityProgressionEvents.checkForStyleUnlocks(event.getPlayer());
        AbilityProgressionEvents.checkForRacialUnlocks(event.getPlayer());
        AbilityProgressionEvents.checkForHakiUnlocks(event.getPlayer());
        AbilityValidationEvents.validateUnlockedAbilities((LivingEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void onEquipmentUpdate(LivingEquipmentChangeEvent event) {
        ItemStack toStack = event.getTo();
        if (event.getEntityLiving() instanceof PlayerEntity) {
            AbilityProgressionEvents.checkForEquipmentUnlocks(event.getEntityLiving());
            if (toStack.func_77973_b().equals(ModArmors.PIRATE_CAPTAIN_CAPE.get())) {
                Crew crew = ExtendedWorldData.get().getCrewWithMember(event.getEntityLiving().func_110124_au());
                CaptainCapeItem.setCapeCrew(toStack, crew);
            }
        }
    }

    @SubscribeEvent
    public static void onFruitAbilityUnlocked(UnlockAbilityEvent event) {
        if (event.getAbilityCore().getCategory() == AbilityCategory.DEVIL_FRUITS) {
            IDevilFruit devilFruitProps = DevilFruitCapability.get(event.getEntityLiving());
            if (devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) && !((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive(event.getEntityLiving())) {
                event.setResult(Event.Result.DENY);
                return;
            }
            ItemStack df = new ItemStack((IItemProvider)devilFruitProps.getDevilFruitItem());
            if (!df.func_190926_b()) {
                if (devilFruitProps.hasYamiPower()) {
                    ItemStack yami = new ItemStack((IItemProvider)ModAbilities.YAMI_YAMI_NO_MI);
                    AbilityCore[] abilityCoreArray = ((AkumaNoMiItem)yami.func_77973_b()).getAbilities();
                    int n = abilityCoreArray.length;
                    for (int i = 0; i < n; ++i) {
                        AbilityCore core = abilityCoreArray[i];
                        if (!event.getAbilityCore().equals(core)) continue;
                        event.setResult(Event.Result.ALLOW);
                    }
                }
                for (AbilityCore core : ((AkumaNoMiItem)df.func_77973_b()).getAbilities()) {
                    boolean canUnlock;
                    if (!event.getAbilityCore().equals(core)) continue;
                    boolean bl = canUnlock = core.hasUnlockCheck() ? core.canUnlock(event.getEntityLiving()) : true;
                    if (!canUnlock) continue;
                    event.setResult(Event.Result.ALLOW);
                }
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private static boolean checkCategoryForNewUnlocks(LivingEntity entity, AbilityCategory category) {
        long updates = ModValues.abilityCategoryMap.get((Object)category).stream().map(core -> AbilityHelper.checkAndUnlockAbility(entity, core)).filter(b -> b).collect(Collectors.counting());
        return updates != 0L;
    }

    public static void checkAllForNewUnlocks(PlayerEntity player) {
        long updates = ModRegistries.ABILITIES.getValues().stream().map(core -> AbilityHelper.checkAndUnlockAbility((LivingEntity)player, core)).filter(b -> b).collect(Collectors.counting());
        if (updates != 0L) {
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), AbilityDataCapability.get((LivingEntity)player)), player);
        }
    }

    public static void checkForDevilFruitUnlocks(PlayerEntity player) {
        if (AbilityProgressionEvents.checkCategoryForNewUnlocks((LivingEntity)player, AbilityCategory.DEVIL_FRUITS)) {
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), AbilityDataCapability.get((LivingEntity)player)), player);
        }
    }

    public static void checkForEquipmentUnlocks(LivingEntity entity) {
        if (AbilityProgressionEvents.checkCategoryForNewUnlocks(entity, AbilityCategory.EQUIPMENT) && entity instanceof ServerPlayerEntity) {
            WyNetwork.sendTo(new SSyncAbilityDataPacket(entity.func_145782_y(), AbilityDataCapability.get(entity)), (PlayerEntity)((ServerPlayerEntity)entity));
        }
    }

    public static void checkForFactionUnlocks(PlayerEntity player) {
        if (AbilityProgressionEvents.checkCategoryForNewUnlocks((LivingEntity)player, AbilityCategory.FACTION)) {
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), AbilityDataCapability.get((LivingEntity)player)), player);
        }
    }

    public static void checkForStyleUnlocks(PlayerEntity player) {
        if (AbilityProgressionEvents.checkCategoryForNewUnlocks((LivingEntity)player, AbilityCategory.STYLE)) {
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), AbilityDataCapability.get((LivingEntity)player)), player);
        }
    }

    public static void checkForRacialUnlocks(PlayerEntity player) {
        if (AbilityProgressionEvents.checkCategoryForNewUnlocks((LivingEntity)player, AbilityCategory.RACIAL)) {
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), AbilityDataCapability.get((LivingEntity)player)), player);
        }
    }

    public static void checkForHakiUnlocks(PlayerEntity player) {
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        boolean updates = AbilityProgressionEvents.checkCategoryForNewUnlocks((LivingEntity)player, AbilityCategory.HAKI);
        if (updates) {
            WyNetwork.sendTo(new SSyncHakiDataPacket(player.func_145782_y(), hakiProps), player);
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), AbilityDataCapability.get((LivingEntity)player)), player);
        }
    }

    public static void forceAdvancementChecks(ServerPlayerEntity player) {
        for (AbilityCoreUnlockWrapper unlockWrapper : AbilityDataCapability.get((LivingEntity)player).getUnlockedAbilities()) {
            ModAdvancements.UNLOCK_ABILITY.trigger(player, unlockWrapper.getAbilityCore());
        }
    }
}

