/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.abilities;

import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.horo.MiniHollowAbility;
import xyz.pixelatedw.mineminenomi.abilities.horo.NegativeHollowAbility;
import xyz.pixelatedw.mineminenomi.abilities.horo.TokuHollowAbility;
import xyz.pixelatedw.mineminenomi.abilities.horo.YutaiRidatsuAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.OutOfBodyAbility;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingAttackEvent;
import xyz.pixelatedw.mineminenomi.api.events.ability.AbilityUseEvent;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class OutOfBodyAbilitiesEvents {
    @SubscribeEvent
    public static void onAbilityUse(AbilityUseEvent.Pre event) {
        LivingEntity entity = event.getEntityLiving();
        Optional<OutOfBodyAbility> ability = OutOfBodyAbilitiesEvents.getOOBAbility(entity);
        if (ability != null && ability.isPresent()) {
            if (event.getAbility().equals(ability.get())) {
                return;
            }
            if (ability.get() instanceof YutaiRidatsuAbility && (event.getAbility() instanceof MiniHollowAbility || event.getAbility() instanceof NegativeHollowAbility || event.getAbility() instanceof TokuHollowAbility)) {
                return;
            }
        }
        if (OutOfBodyAbilitiesEvents.isSpirit(entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player = event.getPlayer();
        if (!OutOfBodyAbilitiesEvents.isSpirit((LivingEntity)player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!OutOfBodyAbilitiesEvents.isSpirit((LivingEntity)player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onItemTossed(ItemTossEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!OutOfBodyAbilitiesEvents.isSpirit((LivingEntity)player)) {
            return;
        }
        event.setCanceled(true);
        player.func_191521_c(event.getEntityItem().func_92059_d());
    }

    @SubscribeEvent
    public static void onEntityHits(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!OutOfBodyAbilitiesEvents.isSpirit((LivingEntity)player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityLeftClickBlocks(PlayerInteractEvent.LeftClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (!OutOfBodyAbilitiesEvents.isSpirit((LivingEntity)player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityRightClickBlocks(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (!OutOfBodyAbilitiesEvents.isSpirit((LivingEntity)player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityBreaksBlocks(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!OutOfBodyAbilitiesEvents.isSpirit((LivingEntity)player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityPlaceBlocks(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!OutOfBodyAbilitiesEvents.isSpirit((LivingEntity)player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityAttackEvent(WyLivingAttackEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (OutOfBodyAbilitiesEvents.isSpirit((LivingEntity)player) && !event.getSource().equals(ModDamageSource.OUT_OF_BODY)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntitySetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity) {
            PlayerEntity player = (PlayerEntity)event.getTarget();
            MobEntity mob = (MobEntity)event.getEntityLiving();
            if (!OutOfBodyAbilitiesEvents.isSpirit((LivingEntity)player)) {
                return;
            }
            mob.func_70624_b(null);
        }
    }

    public static Optional<OutOfBodyAbility> getOOBAbility(LivingEntity entity) {
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        if (abilityProps == null) {
            return Optional.empty();
        }
        Optional<OutOfBodyAbility> optional = abilityProps.getEquippedAbilities(abl -> abl instanceof OutOfBodyAbility && ((OutOfBodyAbility)abl).isContinuous()).stream().map(abl -> (OutOfBodyAbility)abl).findFirst();
        return optional;
    }

    public static boolean isSpirit(LivingEntity entity) {
        if (entity instanceof PlayerEntity && (((PlayerEntity)entity).func_184812_l_() || entity.func_175149_v())) {
            return false;
        }
        Optional<OutOfBodyAbility> ability = OutOfBodyAbilitiesEvents.getOOBAbility(entity);
        return ability != null && ability.isPresent() && !ability.get().isPhysical();
    }
}

