/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.devilfruits;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.LeavesBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.api.OneFruitEntry;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.events.onefruit.DroppedDevilFruitEvent;
import xyz.pixelatedw.mineminenomi.api.events.onefruit.InventoryDevilFruitEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.world.OFPWWorldData;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class OneFruitPerWorldEvents {
    private static final Pair<ResourceLocation, ResourceLocation> OFFHAND_TEXTURE = Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.getWorld().field_72995_K && event.getTarget() instanceof ArmorStandEntity && event.getItemStack().func_77973_b() instanceof AkumaNoMiItem && CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        double chance;
        boolean hasShears;
        boolean bl = hasShears = event.getPlayer().func_184586_b(event.getPlayer().func_184600_cs()).func_77973_b() == Items.field_151097_aZ;
        if (CommonConfig.INSTANCE.getDevilFruitDropsFromLeavesChance() > 0.0 && event.getState().func_177230_c() instanceof LeavesBlock && !hasShears && (chance = event.getWorld().func_201674_k().nextDouble() * 100.0) < CommonConfig.INSTANCE.getDevilFruitDropsFromLeavesChance()) {
            AkumaNoMiItem df = ModValues.DEVIL_FRUITS.get((int)WyHelper.randomWithRange(0, ModValues.DEVIL_FRUITS.size() - 1));
            df = DevilFruitHelper.findAvailableOneFruit((World)event.getWorld(), df);
            if (df != null) {
                boolean flag;
                boolean bl2 = flag = !CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic() || OFPWWorldData.get().updateOneFruit(df.getRegistryName(), null, OneFruitEntry.Status.DROPPED, "Dropped from leaves. Sheared by " + event.getPlayer().func_145748_c_());
                if (flag) {
                    ItemStack stack = df.func_190903_i();
                    ItemEntity item = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), stack);
                    event.getWorld().func_217376_c((Entity)item);
                }
                DroppedDevilFruitEvent postEvent = new DroppedDevilFruitEvent((LivingEntity)event.getPlayer(), df, "Dropped from leaves. Sheared by " + event.getPlayer().func_145748_c_());
                MinecraftForge.EVENT_BUS.post((Event)postEvent);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void mouseClickEvent(GuiScreenEvent.MouseClickedEvent.Pre event) {
        Slot slot;
        if (Minecraft.func_71410_x().field_71439_g == null || !CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            return;
        }
        if (event.getGui() instanceof ContainerScreen && (slot = ((ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && slot.func_225517_c_() != null && slot.func_225517_c_().equals(OFFHAND_TEXTURE)) {
            event.setCanceled(true);
            return;
        }
        ItemStack cap = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (!(cap.func_77973_b() instanceof AkumaNoMiItem) || event.getGui() instanceof CreativeScreen) {
            return;
        }
        if (!(event.getGui() instanceof InventoryScreen)) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void mouseReleaseEvent(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        Slot slot;
        if (Minecraft.func_71410_x().field_71439_g == null || !CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            return;
        }
        if (event.getGui() instanceof ContainerScreen && (slot = ((ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && slot.func_225517_c_() != null && slot.func_225517_c_().equals(OFFHAND_TEXTURE)) {
            event.setCanceled(true);
            return;
        }
        ItemStack cap = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (!(cap.func_77973_b() instanceof AkumaNoMiItem) || event.getGui() instanceof CreativeScreen) {
            return;
        }
        if (!(event.getGui() instanceof InventoryScreen)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
    }

    @SubscribeEvent
    public static void onContainerClose(PlayerContainerEvent.Close event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic() && !(event.getContainer() instanceof PlayerContainer)) {
            int containerSlots = event.getContainer().field_75151_b.size() - event.getPlayer().field_71071_by.field_70462_a.size();
            for (int i = 0; i < containerSlots; ++i) {
                Slot slot = (Slot)event.getContainer().field_75151_b.get(i);
                if (!slot.func_75216_d() || !(slot.func_75211_c().func_77973_b() instanceof AkumaNoMiItem)) continue;
                if (!(event.getContainer() instanceof RepairContainer)) {
                    event.getPlayer().func_71019_a(slot.func_75211_c().func_77946_l(), true);
                }
                slot.func_75209_a(1);
            }
            OneFruitPerWorldEvents.dropFruitsFromNearbyContainers(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic() && event.getTarget() instanceof ItemFrameEntity && !event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof AkumaNoMiItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        IDevilFruit fruitProps = DevilFruitCapability.get(entity);
        OFPWWorldData worldData = OFPWWorldData.get();
        IDevilFruit props = DevilFruitCapability.get(entity);
        boolean fruitRespawned = DevilFruitHelper.respawnDevilFruit(entity, props);
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (!fruitRespawned && CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
                if ((!fruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) || ((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive((LivingEntity)player)) && DevilFruitHelper.canDevilFruitRespawn() && fruitProps.getDevilFruit().isPresent()) {
                    worldData.lostOneFruit(fruitProps.getDevilFruit().get(), (LivingEntity)player, "User's death");
                }
                if (fruitProps.hasYamiPower() && DevilFruitHelper.canDevilFruitRespawn()) {
                    worldData.lostOneFruit(ModAbilities.YAMI_YAMI_NO_MI.getRegistryName(), (LivingEntity)player, "User died");
                }
                ArrayList slots = new ArrayList();
                slots.addAll(player.field_71071_by.field_70462_a);
                slots.addAll(player.field_71071_by.field_184439_c);
                for (ItemStack invStack : slots) {
                    if (invStack == null || !(invStack.func_77973_b() instanceof AkumaNoMiItem)) continue;
                    ResourceLocation key = invStack.func_77973_b().getRegistryName();
                    if (worldData.isFruitInUse(key)) {
                        invStack.func_190918_g(invStack.func_190916_E());
                        continue;
                    }
                    if (player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) continue;
                    worldData.updateOneFruit(key, player.func_110124_au(), OneFruitEntry.Status.DROPPED);
                    DroppedDevilFruitEvent postEvent = new DroppedDevilFruitEvent((LivingEntity)player, DevilFruitHelper.getDevilFruitItem(key), "User died");
                    MinecraftForge.EVENT_BUS.post((Event)postEvent);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getWorld().field_72995_K && CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            OFPWWorldData worldData = OFPWWorldData.get();
            IDevilFruit fruitData = DevilFruitCapability.get((LivingEntity)player);
            IAbilityData abilityData = AbilityDataCapability.get((LivingEntity)player);
            if (CommonConfig.INSTANCE.getDaysForInactivity() > 0) {
                for (OneFruitEntry entry : worldData.getOneFruitEntries()) {
                    boolean nobodyHasFruit;
                    Date date = entry.getLastUpdate();
                    long diff = WyHelper.getDaysSince(date);
                    if (diff >= (long)CommonConfig.INSTANCE.getDaysForInactivity()) {
                        worldData.lostOneFruit(entry.getKey(), null, "Inactivity for " + diff + " days");
                    }
                    boolean somebodyElseHasFruit = entry.getOwner().isPresent() && !entry.getOwner().get().equals(player.func_110124_au());
                    boolean bl = nobodyHasFruit = !entry.getOwner().isPresent() && entry.getStatus() == OneFruitEntry.Status.LOST;
                    if (!somebodyElseHasFruit && !nobodyHasFruit || !fruitData.getDevilFruit().isPresent() || !entry.getKey().equals((Object)fruitData.getDevilFruit().get())) continue;
                    fruitData.removeDevilFruit();
                    abilityData.clearUnlockedAbilities(AbilityCategory.DEVIL_FRUITS.isCorePartofCategory());
                    abilityData.clearPassiveAbilities(AbilityCategory.DEVIL_FRUITS.isAbilityPartofCategory());
                    abilityData.clearEquippedAbilities(AbilityCategory.DEVIL_FRUITS.isAbilityPartofCategory());
                    WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), fruitData), player);
                    player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.SYSTEM_MESSAGE_OFPW_INACTIVITY), Util.field_240973_b_);
                }
            }
            if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
                OneFruitPerWorldEvents.dropFruitsFromNearbyContainers((PlayerEntity)event.getEntity());
            }
            OneFruitPerWorldEvents.checkPlayerInventory(player);
        }
    }

    @SubscribeEvent
    public static void onEntityLeavesWorld(PlayerEvent.PlayerLoggedOutEvent event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            PlayerEntity player = event.getPlayer();
            IDevilFruit dfProps = DevilFruitCapability.get((LivingEntity)player);
            OFPWWorldData worldData = OFPWWorldData.get();
            ArrayList<ResourceLocation> fruits = new ArrayList<ResourceLocation>();
            if (dfProps.hasAnyDevilFruit()) {
                fruits.add(dfProps.getDevilFruit().get());
            }
            if (dfProps.hasYamiPower()) {
                fruits.add(ModAbilities.YAMI_YAMI_NO_MI.getRegistryName());
            }
            PlayerInventory inv = player.field_71071_by;
            for (ItemStack stack : inv.field_70462_a) {
                if (!(stack.func_77973_b() instanceof AkumaNoMiItem)) continue;
                fruits.add(stack.func_77973_b().getRegistryName());
            }
            if (!fruits.isEmpty()) {
                for (ResourceLocation fruit : fruits) {
                    worldData.forceUpdateOneFruit(fruit);
                }
            }
        }
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            OneFruitPerWorldEvents.dropFruitsFromNearbyContainers((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onItemPickedUp(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItem().func_92059_d();
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
                if (stack.func_77973_b() == Items.field_221970_gq && stack.func_77942_o()) {
                    ListNBT items = stack.func_196082_o().func_74775_l("BlockEntityTag").func_150295_c("Items", 10);
                    for (int i = 0; i < items.size(); ++i) {
                        CompoundNBT itemNBT = items.func_150305_b(i);
                        String itemId = itemNBT.func_74779_i("id");
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
                        if (item == null || !(item instanceof AkumaNoMiItem)) continue;
                        items.remove(i);
                    }
                } else if (stack.func_77973_b() instanceof AkumaNoMiItem) {
                    boolean canYamiPickupFruit;
                    IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
                    int fruitsFound = ItemsHelper.getAllInventoryItems((LivingEntity)player).stream().filter(itemStack -> itemStack.func_77973_b() instanceof AkumaNoMiItem).collect(Collectors.toList()).size();
                    boolean bl = canYamiPickupFruit = devilFruitProps.getDevilFruit().equals("yami_yami") && CommonConfig.INSTANCE.isYamiPowerEnabled() && fruitsFound == 0;
                    if (devilFruitProps.hasAnyDevilFruit() && CommonConfig.INSTANCE.getUnableToPickDFAsUser() && !canYamiPickupFruit) {
                        event.setCanceled(true);
                        return;
                    }
                    if (DevilFruitHelper.hasDFLimitInInventory(player)) {
                        event.setCanceled(true);
                    } else {
                        OFPWWorldData worldProps = OFPWWorldData.get();
                        boolean flag = worldProps.updateOneFruit(stack.func_77973_b().getRegistryName(), player.func_110124_au(), OneFruitEntry.Status.INVENTORY);
                        event.setCanceled(!flag);
                        InventoryDevilFruitEvent inventoryEvent = new InventoryDevilFruitEvent((LivingEntity)player, stack.func_77973_b(), "Picked up from ground");
                        MinecraftForge.EVENT_BUS.post((Event)inventoryEvent);
                    }
                } else {
                    OneFruitPerWorldEvents.checkPlayerInventory(player);
                }
            } else if (stack.func_77973_b() instanceof AkumaNoMiItem) {
                OFPWWorldData worldProps = OFPWWorldData.get();
                boolean flag = worldProps.updateOneFruit(stack.func_77973_b().getRegistryName(), player.func_110124_au(), OneFruitEntry.Status.INVENTORY, "Picked up from ground");
                event.setCanceled(!flag);
                InventoryDevilFruitEvent inventoryEvent = new InventoryDevilFruitEvent((LivingEntity)player, stack.func_77973_b(), "Picked up from ground");
                MinecraftForge.EVENT_BUS.post((Event)inventoryEvent);
                OneFruitPerWorldEvents.checkPlayerInventory(player);
            }
        }
    }

    @SubscribeEvent
    public static void onDevilFruitDropped(EntityJoinWorldEvent event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic() && event.getEntity() instanceof ItemEntity) {
            ItemEntity entity = (ItemEntity)event.getEntity();
            ItemStack stack = entity.func_92059_d();
            UUID thrower = entity.func_200214_m();
            PlayerEntity player = null;
            if (thrower != null) {
                player = event.getWorld().func_217371_b(thrower);
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof AkumaNoMiItem) {
                OFPWWorldData worldProps = OFPWWorldData.get();
                String position = "" + entity.func_233580_cy_().func_177958_n() + ", " + entity.func_233580_cy_().func_177956_o() + ", " + entity.func_233580_cy_().func_177952_p();
                boolean flag = worldProps.updateOneFruit(stack.func_77973_b().getRegistryName(), entity.func_200214_m(), OneFruitEntry.Status.DROPPED, "Fruit got dopped " + (player == null ? "" : "by " + player.func_145748_c_().getString() + " at " + position), true);
                event.setCanceled(!flag);
                DroppedDevilFruitEvent postEvent = new DroppedDevilFruitEvent((LivingEntity)player, stack.func_77973_b(), "Fruit got added to world " + (player == null ? "" : "by " + player.func_145748_c_().getString()));
                MinecraftForge.EVENT_BUS.post((Event)postEvent);
            }
        }
    }

    @SubscribeEvent
    public static void onExpire(ItemExpireEvent event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic() && event.getEntityItem().func_92059_d().func_77973_b() instanceof AkumaNoMiItem) {
            ItemStack itemStack = event.getEntityItem().func_92059_d();
            AkumaNoMiItem item = (AkumaNoMiItem)itemStack.func_77973_b();
            OFPWWorldData worldData = OFPWWorldData.get();
            worldData.lostOneFruit(item.getRegistryName(), null, "Item Entity expired on ground");
        }
    }

    private static void dropFruitsFromNearbyContainers(PlayerEntity player) {
        List<BlockPos> blockPosList = WyHelper.getNearbyTileEntities((Entity)player, 40);
        for (BlockPos pos : blockPosList) {
            TileEntity te = player.field_70170_p.func_175625_s(pos);
            if (!(te instanceof IInventory)) continue;
            for (int i = 0; i < ((IInventory)te).func_70302_i_(); ++i) {
                ItemStack stack = ((IInventory)te).func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof AkumaNoMiItem)) continue;
                player.func_71019_a(stack.func_77946_l(), false);
                stack.func_190918_g(stack.func_190916_E());
            }
        }
    }

    public static void checkPlayerInventory(PlayerEntity player) {
        OFPWWorldData worldProps = OFPWWorldData.get();
        IDevilFruit fruitData = DevilFruitCapability.get((LivingEntity)player);
        ArrayList slots = new ArrayList();
        slots.addAll(player.field_71071_by.field_70462_a);
        slots.addAll(player.field_71071_by.field_184439_c);
        int fruitsFound = 0;
        for (ItemStack stack : slots) {
            if (stack == null || !(stack.func_77973_b() instanceof AkumaNoMiItem)) continue;
            ResourceLocation key = stack.func_77973_b().getRegistryName();
            ++fruitsFound;
            if (worldProps.isFruitInUse(key)) {
                stack.func_190918_g(stack.func_190916_E());
                continue;
            }
            if (worldProps.isFruitDuped(key, player.func_110124_au())) {
                stack.func_190918_g(stack.func_190916_E());
                continue;
            }
            if (fruitData.hasAnyDevilFruit() && CommonConfig.INSTANCE.getUnableToPickDFAsUser()) {
                if (fruitData.hasDevilFruit(ModAbilities.YAMI_YAMI_NO_MI) && CommonConfig.INSTANCE.isYamiPowerEnabled() && fruitsFound == 1) continue;
                if (!worldProps.isFruitDuped(key, player.func_110124_au())) {
                    worldProps.lostOneFruit(key, null, "Cannot pick up extra fruits");
                }
                stack.func_190918_g(stack.func_190916_E());
                continue;
            }
            if (fruitsFound <= CommonConfig.INSTANCE.getInventoryLimitForFruits()) continue;
            if (!worldProps.isFruitDuped(key, player.func_110124_au())) {
                worldProps.lostOneFruit(key, null, "Cannot pick up more than " + CommonConfig.INSTANCE.getInventoryLimitForFruits() + " fruits");
            }
            stack.func_190918_g(stack.func_190916_E());
        }
    }
}

