/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.devilfruits;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.packets.server.randfruit.SSetFruitSeedsPacket;
import xyz.pixelatedw.mineminenomi.packets.server.randfruit.SSetRandomizedFruitsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class RandomFruitEvents {

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT, Dist.DEDICATED_SERVER})
    public static class Common {
        public static long SEED;

        @SubscribeEvent
        public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
            if (event.getEntity() instanceof PlayerEntity && !event.getEntity().field_70170_p.field_72995_K) {
                PlayerEntity player = (PlayerEntity)event.getEntity();
                WyNetwork.sendTo(new SSetRandomizedFruitsPacket(CommonConfig.INSTANCE.getRandomizedFruits()), player);
                if (CommonConfig.INSTANCE.getRandomizedFruits()) {
                    HashMap<Integer, Long> seeds = new HashMap<Integer, Long>();
                    Random rand = new Random(((ServerWorld)player.field_70170_p).func_72905_C());
                    long worldSeed = rand.nextLong();
                    for (AkumaNoMiItem fruit : ModValues.DEVIL_FRUITS) {
                        ResourceLocation res = fruit.getRegistryName();
                        if (res == null) continue;
                        int key = res.hashCode();
                        long seed = worldSeed + (long)key;
                        seeds.put(key, seed);
                    }
                    SEED = worldSeed;
                    WyNetwork.sendTo(new SSetFruitSeedsPacket(seeds, worldSeed), player);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerUsesItem(PlayerInteractEvent.RightClickItem event) {
            DFEncyclopediaEntry entry;
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack stack = event.getItemStack();
            if (stack.func_190926_b() || stack.func_77973_b() != Items.field_151121_aF || stack.func_77978_p() == null || stack.func_77978_p().isEmpty() || player.field_70170_p.field_72995_K) {
                return;
            }
            if (stack.func_179543_a("fruitClues") == null) {
                return;
            }
            if (!CommonConfig.INSTANCE.getRandomizedFruits()) {
                player.func_145747_a((ITextComponent)ModI18n.SYSTEM_MESSAGE_RANDOMIZED_FRUITS, Util.field_240973_b_);
                return;
            }
            CompoundNBT nbt = stack.func_179543_a("fruitClues");
            ResourceLocation key = new ResourceLocation(nbt.func_74779_i("key"));
            boolean flag = ItemsHelper.updateEncyclopediae(player, key, entry = DFEncyclopediaEntry.of(nbt));
            if (flag) {
                stack.func_190918_g(1);
                ItemStack fruit = DevilFruitHelper.getDevilFruitItemStack(key);
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_MESSAGE_GAINED_FRUIT_CLUE, new Object[]{fruit.func_200301_q().getString()}), Util.field_240973_b_);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
    public static class Client {
        public static boolean HAS_RANDOMIZED_FRUIT = false;
        public static boolean DIRTY = false;
        public static HashMap<Integer, Long> FRUIT_SEEDS = new HashMap();

        @SubscribeEvent
        public static void onTooltipRendered(ItemTooltipEvent event) {
            if (HAS_RANDOMIZED_FRUIT && event.getItemStack() != null && event.getItemStack().func_77973_b() instanceof AkumaNoMiItem) {
                ItemStack stack = event.getItemStack();
                boolean isFound = stack.func_196082_o().func_74767_n("deciphered");
                event.getToolTip().clear();
                TranslationTextComponent name = new TranslationTextComponent(ModI18n.ITEM_GENERIC_FRUIT);
                if (isFound) {
                    name = new StringTextComponent("").func_230529_a_(event.getItemStack().func_200301_q()).func_240699_a_(event.getItemStack().func_77953_t().field_77937_e);
                }
                event.getToolTip().add(name);
            }
        }
    }
}

