/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.mixins.ILivingEntityMixin;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class ModAttributes {
    private static final int JUMP_TICK_DELAY = 1;
    private static final int MAX_JUMP_TICKS = 9;
    public static final RegistryObject<Attribute> FALL_RESISTANCE = WyRegistry.registerAttribute("Fall Resistance", () -> new RangedAttribute("attribute.name.generic.mineminenomi.fall_resistance", 0.0, -256.0, 256.0));
    public static final RegistryObject<Attribute> JUMP_HEIGHT = WyRegistry.registerAttribute("Jump Height", () -> new RangedAttribute("attribute.name.generic.mineminenomi.jump_height", 1.252203277664432, -256.0, 256.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> REGEN_RATE = WyRegistry.registerAttribute("Regen Rate", () -> new RangedAttribute("attribute.name.generic.mineminenomi.regen_rate", 1.0, 0.0, 32.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> STEP_HEIGHT = WyRegistry.registerAttribute("Step Height", () -> new RangedAttribute("attribute.name.generic.mineminenomi.step_height", 0.6, 0.0, 20.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> DAMAGE_REDUCTION = WyRegistry.registerAttribute("Damage Reduction", () -> new RangedAttribute("attribute.name.generic.mineminenomi.damage_reduction", 0.0, -2.0, 0.999).func_233753_a_(true));
    public static final RegistryObject<Attribute> ATTACK_RANGE = WyRegistry.registerAttribute("Attack Range", () -> new RangedAttribute("attribute.name.generic.mineminenomi.attack_range", 0.0, -1024.0, 1024.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> PUNCH_DAMAGE = WyRegistry.registerAttribute("Punch Damage", () -> new RangedAttribute("attribute.name.generic.mineminenomi.punch_damage", 0.0, -1024.0, 1024.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> TIME_PROGRESSION = WyRegistry.registerAttribute("Time Progression", () -> new RangedAttribute("attribute.name.generic.mineminenomi.time_progression", 1.0, 0.0, 1024.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> FLOATING_TIME = WyRegistry.registerAttribute("Floating Time", () -> new RangedAttribute("attribute.name.generic.mineminenomi.floating_time", 100.0, 0.0, 2048.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> TOUGHNESS = WyRegistry.registerAttribute("Toughness", () -> new RangedAttribute("attribute.name.generic.mineminenomi.toughness", 0.0, 0.0, 20.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> GCD = WyRegistry.registerAttribute("GCD", () -> new RangedAttribute("attribute.name.generic.mineminenomi.gcd", 40.0, -72000.0, 72000.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> MINING_SPEED = WyRegistry.registerAttribute("Mining Speed", () -> new RangedAttribute("attribute.name.generic.mineminenomi.mining_speed", 1.0, -128.0, 128.0).func_233753_a_(true));
    @Deprecated
    public static final RegistryObject<Attribute> FAUX_PROTECTION = WyRegistry.registerAttribute("Faux Protection", () -> new RangedAttribute("attribute.name.generic.mineminenomi.faux_protection", 0.0, 0.0, 20.0).func_233753_a_(true));

    public static void register(IEventBus eventBus) {
        WyRegistry.ATTRIBUTES.register(eventBus);
    }

    @Mod.EventBusSubscriber(modid="mineminenomi")
    public static class Defaults {
        public static double velocityToHeight(double velocity, double gravity, double drag) {
            double yPos = 0.0;
            while (velocity >= 0.0) {
                yPos += velocity;
                velocity = (velocity - gravity) * drag;
            }
            return yPos;
        }

        public static double simulateHeightWithVelocityBoost(double estimatedVelocity, double initialVelocity, double gravity, double drag, int maxTicks, int tickDelay) {
            double yPos = 0.0;
            for (int i = 0; i < 10000; ++i) {
                yPos += initialVelocity;
                initialVelocity = (initialVelocity - gravity) * drag;
                if (i >= tickDelay && i < tickDelay + maxTicks) {
                    initialVelocity += estimatedVelocity * Math.pow(drag, i - tickDelay);
                }
                if (initialVelocity < 0.0) break;
            }
            return yPos;
        }

        public static double getVelocityForHeight(double initialVelocity, double gravity, double drag, int maxTicks, int tickDelay, double desiredMove) {
            double lo = -10.0;
            double hi = 10.0;
            for (int i = 0; i < 50; ++i) {
                double mid = 0.5 * (lo + hi);
                double midHeight = Defaults.simulateHeightWithVelocityBoost(mid, initialVelocity, gravity, drag, maxTicks, tickDelay);
                if (Math.abs(midHeight - desiredMove) < 6.0E-6) {
                    return mid;
                }
                if (midHeight < desiredMove) {
                    lo = mid;
                    continue;
                }
                hi = mid;
            }
            return 0.5 * (lo + hi);
        }

        @SubscribeEvent
        public static void onTick(LivingEvent.LivingUpdateEvent event) {
            ModifiableAttributeInstance attributeInstance;
            LivingEntity entity = event.getEntityLiving();
            IEntityStats entityDataProps = EntityStatsCapability.get(entity);
            if (entityDataProps.isJumping()) {
                ModifiableAttributeInstance jumpHeight = entity.func_110148_a((Attribute)JUMP_HEIGHT.get());
                if (jumpHeight != null && entityDataProps.getJumpTicks() >= 1 && entityDataProps.getJumpTicks() < 10) {
                    double gravityValue = entity.func_233637_b_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                    double jumpPower = ((ILivingEntityMixin)entity).invokeGetJumpPower();
                    double baseHeight = Defaults.velocityToHeight(jumpPower, gravityValue, 0.98);
                    double jumpHeightValue = jumpHeight.func_111126_e() - baseHeight;
                    if (jumpHeightValue > 0.0) {
                        double adjustedMove = jumpHeightValue + baseHeight;
                        double velocity = Defaults.getVelocityForHeight(jumpPower, gravityValue, 0.98, 9, 1, adjustedMove);
                        double tickVelocity = velocity * Math.pow(0.98, entityDataProps.getJumpTicks() - 1);
                        double yRot = (double)entity.field_70177_z * Math.PI / 180.0;
                        double leapPower = (entity.func_213322_ci().field_72448_b + tickVelocity) * 0.2;
                        double velocityX = entity.func_70051_ag() && tickVelocity > 0.0 ? -Math.sin(yRot) * leapPower : 0.0;
                        double velocityZ = entity.func_70051_ag() && tickVelocity > 0.0 ? Math.cos(yRot) * leapPower : 0.0;
                        entity.func_70024_g(velocityX, tickVelocity, velocityZ);
                    }
                }
                entityDataProps.alterJumpTicks(1);
            } else {
                entityDataProps.setJumpTicks(10);
            }
            if (entity.func_233570_aj_()) {
                entityDataProps.setJumpTicks(0);
            }
            if ((attributeInstance = entity.func_110148_a((Attribute)STEP_HEIGHT.get())) != null) {
                float newStepHeight;
                entity.field_70138_W = newStepHeight = (float)attributeInstance.func_111126_e();
            }
        }

        @SubscribeEvent
        public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
            PlayerEntity player = event.getPlayer();
            ModifiableAttributeInstance attributeInstance = player.func_110148_a((Attribute)MINING_SPEED.get());
            if (attributeInstance != null) {
                event.setNewSpeed((float)((double)event.getOriginalSpeed() * attributeInstance.func_111126_e()));
            }
        }

        @SubscribeEvent
        public static void onFall(LivingFallEvent e) {
            ModifiableAttributeInstance attributeInstance = e.getEntityLiving().func_110148_a((Attribute)FALL_RESISTANCE.get());
            if (attributeInstance != null) {
                e.setDistance((float)((double)e.getDistance() - attributeInstance.func_111126_e()));
            }
        }

        @SubscribeEvent
        public static void onJump(LivingEvent.LivingJumpEvent event) {
            double value;
            LivingEntity entity = event.getEntityLiving();
            ModifiableAttributeInstance jumpHeight = entity.func_110148_a((Attribute)JUMP_HEIGHT.get());
            if (jumpHeight != null && (value = jumpHeight.func_111126_e()) <= 0.0) {
                entity.func_213293_j(0.0, 0.0, 0.0);
            }
        }

        @SubscribeEvent
        public static void onHeal(LivingHealEvent event) {
            float value;
            ModifiableAttributeInstance attributeInstance = event.getEntityLiving().func_110148_a((Attribute)REGEN_RATE.get());
            if (attributeInstance != null && (value = (float)attributeInstance.func_111126_e()) != 1.0f) {
                event.setAmount(event.getAmount() * value);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mineminenomi", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Setup {
        @SubscribeEvent
        public static void onEntityConstruct(EntityAttributeModificationEvent event) {
            for (EntityType type : event.getTypes()) {
                event.add(type, (Attribute)FALL_RESISTANCE.get());
                event.add(type, (Attribute)JUMP_HEIGHT.get());
                event.add(type, (Attribute)REGEN_RATE.get());
                event.add(type, (Attribute)STEP_HEIGHT.get());
                event.add(type, (Attribute)DAMAGE_REDUCTION.get());
                event.add(type, (Attribute)ATTACK_RANGE.get());
                event.add(type, (Attribute)PUNCH_DAMAGE.get());
                event.add(type, (Attribute)TIME_PROGRESSION.get());
                event.add(type, (Attribute)TOUGHNESS.get());
                event.add(type, (Attribute)GCD.get());
                event.add(type, (Attribute)FAUX_PROTECTION.get());
                if (type == EntityType.field_200729_aH) {
                    event.add(type, (Attribute)MINING_SPEED.get());
                }
                if (type != ModEntities.BIG_DUCK.get()) continue;
                event.add(type, (Attribute)FLOATING_TIME.get());
            }
        }
    }
}

