/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.ModIndirectEntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class ModDamageSource
extends DamageSource {
    public static final ModDamageSource SPECIAL = new ModDamageSource("special", false, false, false);
    public static final ModDamageSource DEVILS_CURSE = (ModDamageSource)new ModDamageSource("devils_curse").setUnavoidable().bypassLogia().func_151518_m().func_76348_h().func_76359_i();
    public static final DamageSource SOULBOUND_DAMAGE = new ModDamageSource("soulbound_damage").setUnavoidable().bypassLogia().func_151518_m().func_76348_h().func_76359_i();
    public static final DamageSource OUT_OF_BODY = new DamageSource("out_of_body").func_76348_h().func_82726_p();
    public static final DamageSource POISON = new ModDamageSource("poison").setSourceElement(SourceElement.POISON).setPiercing(1.0f).setUnavoidable().setInternal().func_82726_p();
    public static final ModDamageSource GENOCIDE_RAID = new ModDamageSource("genocide_raid").setPiercing(0.25f).setSourceElement(SourceElement.METAL);
    public static final ModDamageSource TOO_MUCH_GRAVITY = new ModDamageSource("too_much_gravity").setPiercing(1.0f).setUnavoidable().setSourceElement(SourceElement.GRAVITY);
    public static final ModDamageSource SUN_INCINERATION = (ModDamageSource)new ModDamageSource("sun_incineration").setPiercing(1.0f).setUnavoidable().setSourceElement(SourceElement.FIRE).bypassLogia().func_76361_j().func_151518_m();
    public static final ModDamageSource STORED_DAMAGE = (ModDamageSource)new ModDamageSource("stored_damage").setUnavoidable().bypassLogia().func_151518_m().func_76348_h().func_76359_i();
    private boolean isIndirectDamage = false;
    private boolean canBypassFriendlyDamage = false;
    private SourceElement element = SourceElement.NONE;
    private ArrayList<SourceType> sourceTypes = new ArrayList();
    private SourceHakiNature hakiNature = SourceHakiNature.UNKNOWN;
    private boolean isAoE;
    private boolean bypassLogia;
    private boolean unavoidable;
    private float piercing;
    private boolean ignore;
    private boolean isBlocked;

    public ModDamageSource(DamageSource source) {
        super(source.field_76373_n);
        if (source.func_76363_c()) {
            this.func_76348_h();
        }
        if (source.func_76357_e()) {
            this.func_76359_i();
        }
        if (source.func_151517_h()) {
            this.func_151518_m();
        }
        if (source instanceof ModDamageSource) {
            ModDamageSource msource = (ModDamageSource)source;
            msource.setSourceElement(this.element);
            msource.setSourceTypes(this.sourceTypes);
            msource.setHakiNature(this.hakiNature);
            if (msource.isAreaOfEffect()) {
                msource.setAreaOfEffect();
            }
            if (msource.func_76352_a()) {
                msource.setProjectile();
            }
            if (msource.isBypassingLogia()) {
                msource.bypassLogia();
            }
            msource.setPiercing(this.piercing);
        }
    }

    public ModDamageSource(String damageTypeIn, boolean bypassArmor, boolean isFireDamage, boolean isExplosive) {
        super(damageTypeIn);
        if (bypassArmor) {
            this.func_76348_h();
        }
        if (isFireDamage) {
            this.func_76361_j();
        }
        if (isExplosive) {
            this.func_94540_d();
        }
    }

    public ModDamageSource(String damageType) {
        this(damageType, false, false, false);
    }

    public ModDamageSource setBypassGroupProtection() {
        return this.setBypassFriendlyDamage();
    }

    public boolean bypassesSameGroupProtection() {
        return this.canBypassFriendlyDamage;
    }

    public ModDamageSource setBypassFriendlyDamage() {
        this.canBypassFriendlyDamage = true;
        return this;
    }

    public boolean canBypassFriendlyDamage() {
        return this.canBypassFriendlyDamage;
    }

    public ModDamageSource markIndirectDamage() {
        this.isIndirectDamage = true;
        return this;
    }

    public boolean isIndirectDamage() {
        return this.isIndirectDamage;
    }

    public ModDamageSource ignore() {
        this.ignore = true;
        return this;
    }

    public boolean isIgnored() {
        return this.ignore;
    }

    public ModDamageSource bypassLogia() {
        this.bypassLogia = true;
        return this;
    }

    public boolean isBypassingLogia() {
        return this.bypassLogia;
    }

    public ModDamageSource setPiercing(float pierce) {
        this.piercing = MathHelper.func_76131_a((float)pierce, (float)0.0f, (float)1.0f);
        return this;
    }

    public float getPierce() {
        return this.piercing;
    }

    public boolean isSlash() {
        return this.hasType(SourceType.SLASH);
    }

    public <T extends ModDamageSource> T setSlash() {
        if (!this.sourceTypes.contains((Object)SourceType.SLASH)) {
            this.sourceTypes.add(SourceType.SLASH);
        }
        return (T)((Object)this);
    }

    public boolean isBlunt() {
        return this.hasType(SourceType.BLUNT);
    }

    public <T extends ModDamageSource> T setBlunt() {
        if (!this.sourceTypes.contains((Object)SourceType.BLUNT)) {
            this.sourceTypes.add(SourceType.BLUNT);
        }
        return (T)((Object)this);
    }

    public boolean isInternal() {
        return this.hasType(SourceType.INTERNAL);
    }

    public ModDamageSource setInternal() {
        if (!this.sourceTypes.contains((Object)SourceType.INTERNAL)) {
            this.sourceTypes.add(SourceType.INTERNAL);
        }
        this.func_76348_h();
        this.bypassLogia();
        this.setPiercing(1.0f);
        return this;
    }

    public boolean isUnavoidable() {
        return this.unavoidable || super.func_94541_c();
    }

    public ModDamageSource setUnavoidable() {
        this.unavoidable = true;
        return this;
    }

    public boolean isFistDamage() {
        return this.hasType(SourceType.FIST);
    }

    public ModDamageSource setFistDamage() {
        if (!this.sourceTypes.contains((Object)SourceType.FIST)) {
            this.sourceTypes.add(SourceType.FIST);
        }
        return this;
    }

    public boolean isPhysical() {
        return this.hasType(SourceType.PHYSICAL) || this.isFistDamage();
    }

    public ModDamageSource setPhysical() {
        if (!this.sourceTypes.contains((Object)SourceType.PHYSICAL)) {
            this.sourceTypes.add(SourceType.PHYSICAL);
        }
        return this;
    }

    public boolean isAreaOfEffect() {
        return this.isAoE;
    }

    public ModDamageSource setAreaOfEffect() {
        this.isAoE = true;
        return this;
    }

    public SourceElement getElement() {
        return this.element;
    }

    public ModDamageSource setSourceElement(SourceElement element) {
        this.element = element;
        return this;
    }

    public ArrayList<SourceType> getSourceTypes() {
        if (this.sourceTypes.isEmpty()) {
            return AbilityHelper.NO_SOURCE_TYPE;
        }
        return new ArrayList<SourceType>(this.sourceTypes);
    }

    public ModDamageSource setSourceTypes(ArrayList<SourceType> sourceTypes) {
        this.sourceTypes = sourceTypes;
        return this;
    }

    public boolean hasType(SourceType type) {
        boolean flag = false;
        for (SourceType t : this.sourceTypes) {
            if (!t.equals((Object)type)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public SourceHakiNature getHakiNature() {
        return this.hakiNature;
    }

    public ModDamageSource setHakiNature(SourceHakiNature nature) {
        this.hakiNature = nature;
        return this;
    }

    public ModDamageSource getSource() {
        return this.setSourceProprieties(new ModDamageSource(this.func_76355_l()));
    }

    private ModDamageSource setSourceProprieties(ModDamageSource s) {
        if (this.func_76347_k()) {
            s.func_76361_j();
        }
        if (this.func_94541_c()) {
            s.func_94540_d();
        }
        if (this.func_76363_c()) {
            s.func_76348_h();
        }
        return s;
    }

    public ModDamageSource setProjectile() {
        return this.setSourceProprieties((ModDamageSource)super.func_76349_b());
    }

    public ModDamageSource setBlocked() {
        this.isBlocked = true;
        return this;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    @Nullable
    public Vector3d func_188404_v() {
        if (this.func_76364_f() != null) {
            return this.func_76364_f().func_213303_ch();
        }
        if (this.func_76346_g() != null) {
            return this.func_76346_g().func_213303_ch();
        }
        return null;
    }

    public ITextComponent func_151519_b(LivingEntity entityLivingBaseIn) {
        if (this instanceof AbilityDamageSource) {
            return ((AbilityDamageSource)this).func_151519_b(entityLivingBaseIn);
        }
        return super.func_151519_b(entityLivingBaseIn);
    }

    public ModDamageSource causeIndirectDamageFromSource(ThrowableEntity entity) {
        ModIndirectEntityDamageSource source = new ModIndirectEntityDamageSource(this.func_76355_l(), (Entity)entity, entity.func_234616_v_());
        if (this.func_76347_k()) {
            source.func_76361_j();
        }
        if (this.func_94541_c()) {
            source.func_94540_d();
        }
        if (this.func_76363_c()) {
            source.func_76348_h();
        }
        return source;
    }

    public ModDamageSource causeEntityDamageFromSource(Entity entity) {
        ModEntityDamageSource source = new ModEntityDamageSource(this.func_76355_l(), entity);
        return this.setSourceProprieties(source);
    }

    public static AbilityDamageSource causeAbilityDamage(LivingEntity player, AbilityCore ability) {
        return new AbilityDamageSource("ability", (Entity)player, (AbilityCore<? extends IAbility>)ability);
    }

    public static AbilityDamageSource causeAbilityDamage(LivingEntity player, IAbility ability) {
        return new AbilityDamageSource("ability", (Entity)player, (AbilityCore<? extends IAbility>)ability.getCore());
    }

    public static AbilityDamageSource causeAbilityDamage(LivingEntity player, IAbility ability, String damageType) {
        return new AbilityDamageSource(damageType, (Entity)player, (AbilityCore<? extends IAbility>)ability.getCore());
    }
}

