/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.OneFruitEntry;
import xyz.pixelatedw.mineminenomi.api.events.onefruit.InventoryDevilFruitEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.data.world.OFPWWorldData;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;

public class AkumaNoMiBoxItem
extends Item {
    public static final Pair<Integer, ResourceLocation> TIER_1_FRUITS = ImmutablePair.of((Object)1, (Object)new ResourceLocation("mineminenomi", "dfboxes/wooden_box"));
    public static final Pair<Integer, ResourceLocation> TIER_2_FRUITS = ImmutablePair.of((Object)2, (Object)new ResourceLocation("mineminenomi", "dfboxes/iron_box"));
    public static final Pair<Integer, ResourceLocation> TIER_3_FRUITS = ImmutablePair.of((Object)3, (Object)new ResourceLocation("mineminenomi", "dfboxes/golden_box"));
    private Pair<Integer, ResourceLocation> tier;

    public AkumaNoMiBoxItem(Pair<Integer, ResourceLocation> tier) {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.MISC).func_200917_a(1));
        this.tier = tier;
    }

    public int getKeySlot(PlayerEntity player) {
        if (!player.field_71071_by.func_213902_a((Set)ImmutableSet.of((Object)ModItems.KEY.get()))) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_MESSAGE_NEED_KEY), Util.field_240973_b_);
            return -1;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_190926_b() || stack.func_77973_b() != ModItems.KEY.get()) continue;
            return i;
        }
        return -1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            int keySlot = this.getKeySlot(player);
            if (keySlot < 0) {
                return ActionResult.func_226251_d_((Object)itemStack);
            }
            if (hand == Hand.OFF_HAND) {
                return ActionResult.func_226251_d_((Object)itemStack);
            }
            player.field_71071_by.func_70298_a(keySlot, 1);
            player.field_71071_by.func_184437_d(itemStack);
            OFPWWorldData worldData = OFPWWorldData.get();
            LootTable lootTable = player.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a((ResourceLocation)this.tier.getValue());
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)player.field_70170_p).func_216015_a(LootParameters.field_216281_a, (Object)player);
            LootContext context = builder.func_216022_a(LootParameterSets.field_216260_a);
            List stacks = lootTable.func_216113_a(context);
            ItemStack boxItemStack = ItemStack.field_190927_a;
            for (ItemStack stack : stacks) {
                if (stack == null || stack.func_190926_b()) continue;
                boxItemStack = stack;
                break;
            }
            if (boxItemStack == null) {
                player.field_71071_by.func_184437_d(itemStack);
                return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
            }
            if (!(boxItemStack.func_77973_b() instanceof AkumaNoMiItem)) {
                player.field_71071_by.func_70441_a(boxItemStack);
                return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
            }
            if (DevilFruitHelper.hasDFLimitInInventory(player)) {
                player.func_71019_a(boxItemStack, true);
                return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
            }
            AkumaNoMiItem fruit = (AkumaNoMiItem)boxItemStack.func_77973_b();
            player.field_71071_by.func_70441_a(boxItemStack);
            OFPWWorldData worldProps = OFPWWorldData.get();
            worldProps.updateOneFruit(fruit.getRegistryName(), player.func_110124_au(), OneFruitEntry.Status.INVENTORY, "Obtained from " + itemStack.func_151000_E().getString());
            InventoryDevilFruitEvent event = new InventoryDevilFruitEvent((LivingEntity)player, fruit, "Obtained from " + itemStack.func_151000_E().getString());
            MinecraftForge.EVENT_BUS.post((Event)event);
            return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return ActionResult.func_226248_a_((Object)itemStack);
    }

    public int getTierLevel() {
        return (Integer)this.tier.getKey();
    }
}

