/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.mixins;

import com.google.common.base.Strings;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingAttackEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingDamageEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingHurtEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

@Mixin(value={PlayerEntity.class}, priority=990)
public abstract class PlayerEntityMixin {
    private static final Logger WLOGGER = LogManager.getLogger();
    private WyLivingAttackEvent livingAttackEvent;

    @ModifyConstant(method={"attack(Lnet/minecraft/entity/Entity;)V"}, constant={@Constant(doubleValue=9.0)})
    private double getActualAttackRange(double attackRange) {
        PlayerEntity player = (PlayerEntity)this;
        return AttributeHelper.getSquaredAttackRangeDistance((LivingEntity)player, attackRange);
    }

    @Inject(method={"getDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSize(Pose pose, CallbackInfoReturnable<EntitySize> callback) {
        PlayerEntity player = (PlayerEntity)this;
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        if (!Strings.isNullOrEmpty((String)props.getZoanPoint())) {
            MorphInfo info = MorphHelper.getZoanInfo((LivingEntity)player);
            if (info == null) {
                return;
            }
            Map<Pose, EntitySize> poses = info.getSizes();
            if (poses != null && poses.containsKey(player.func_213283_Z()) && poses.get(player.func_213283_Z()) != null) {
                callback.setReturnValue((Object)poses.get(player.func_213283_Z()));
            }
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/CooldownTracker;tick()V"))
    public void noroTick(CooldownTracker cooldownTracker) {
        PlayerEntity player = (PlayerEntity)this;
        if (player.func_70644_a((Effect)ModEffects.NORO_SLOWNESS.get())) {
            int amplifier = Math.max(5, 5 * player.func_70660_b((Effect)ModEffects.NORO_SLOWNESS.get()).func_76458_c());
            if (player.field_70173_aa % amplifier == 0) {
                cooldownTracker.func_185144_a();
            }
        } else {
            cooldownTracker.func_185144_a();
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;sweepAttack()V", shift=At.Shift.AFTER)})
    public void attackTargetEntityWithCurrentItem(Entity targetEntity, CallbackInfo callback) {
        PlayerEntity player = (PlayerEntity)this;
        targetEntity.field_70172_ad = 0;
        targetEntity.func_70097_a((DamageSource)new EntityDamageSource("sweep_damage", (Entity)player), 0.1f);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        PlayerEntity entity = (PlayerEntity)this;
        this.livingAttackEvent = new WyLivingAttackEvent((LivingEntity)entity, pSource, pAmount);
        MinecraftForge.EVENT_BUS.post((Event)this.livingAttackEvent);
        if (this.livingAttackEvent.isCanceled()) {
            cir.cancel();
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), ordinal=0)
    public DamageSource hurtDamageSource(DamageSource pSource) {
        return this.livingAttackEvent.getSource();
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), ordinal=0)
    public float hurtAmount(float pAmount) {
        return this.livingAttackEvent.getAmount();
    }

    @ModifyArgs(method={"actuallyHurt"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/common/ForgeHooks;onLivingHurt(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/util/DamageSource;F)F", remap=false))
    public void actuallyHurtOnLivingHurt(Args args) {
        LivingEntity entity = (LivingEntity)args.get(0);
        DamageSource damageSource = (DamageSource)args.get(1);
        float amount = ((Float)args.get(2)).floatValue();
        WyLivingHurtEvent event = new WyLivingHurtEvent(entity, damageSource, amount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (Float.isNaN(event.getAmount())) {
            WLOGGER.warn("NaN value received in hurt event, original value was " + amount);
            return;
        }
        if (!event.isCanceled()) {
            args.set(1, (Object)event.getSource());
            args.set(2, (Object)Float.valueOf(event.getAmount()));
        } else {
            args.set(2, (Object)Float.valueOf(0.0f));
        }
    }

    @ModifyArgs(method={"actuallyHurt"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/common/ForgeHooks;onLivingDamage(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/util/DamageSource;F)F", remap=false))
    public void actuallyHurtOnLivingDamage(Args args) {
        LivingEntity entity = (LivingEntity)args.get(0);
        DamageSource damageSource = (DamageSource)args.get(1);
        float amount = ((Float)args.get(2)).floatValue();
        WyLivingDamageEvent event = new WyLivingDamageEvent(entity, damageSource, amount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (Float.isNaN(event.getAmount())) {
            WLOGGER.warn("NaN value received in hurt event, original value was " + amount);
            return;
        }
        if (!event.isCanceled()) {
            args.set(1, (Object)event.getSource());
            args.set(2, (Object)Float.valueOf(event.getAmount()));
        } else {
            args.set(2, (Object)Float.valueOf(0.0f));
        }
    }
}

