/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.mixins.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Optional;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.pixelatedw.mineminenomi.api.effects.ModEffect;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;

@Mixin(value={LivingRenderer.class})
public class LivingRendererMixin<T extends LivingEntity, M extends EntityModel<T>> {
    private Optional<Float> prevYaw = Optional.empty();

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/model/EntityModel;setupAnim(Lnet/minecraft/entity/Entity;FFFFF)V", shift=At.Shift.AFTER)})
    public void renderPost(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, CallbackInfo callback) {
        RendererHelper.animationSetup(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, CallbackInfo callback) {
        LivingEntity leashHolder;
        if (entity instanceof PlayerEntity && (leashHolder = EntityStatsCapability.get(entity).getLeashHolder()) != null) {
            this.renderLeash(entity, partialTicks, matrixStack, buffer, leashHolder);
        }
    }

    private <E extends Entity> void renderLeash(T entity, float pPartialTicks, MatrixStack pMatrixStack, IRenderTypeBuffer pBuffer, E pLeashHolder) {
        pMatrixStack.func_227860_a_();
        Vector3d vector3d = pLeashHolder.func_241843_o(pPartialTicks);
        double d0 = (double)(MathHelper.func_219799_g((float)pPartialTicks, (float)((LivingEntity)entity).field_70761_aq, (float)((LivingEntity)entity).field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vector3d1 = Vector3d.field_186680_a.func_72441_c(0.0, (double)entity.func_213302_cg() / 1.65, 0.0);
        double d1 = Math.cos(d0) * vector3d1.field_72449_c + Math.sin(d0) * vector3d1.field_72450_a;
        double d2 = Math.sin(d0) * vector3d1.field_72449_c - Math.cos(d0) * vector3d1.field_72450_a;
        double d3 = MathHelper.func_219803_d((double)pPartialTicks, (double)((LivingEntity)entity).field_70169_q, (double)entity.func_226277_ct_()) + d1;
        double d4 = MathHelper.func_219803_d((double)pPartialTicks, (double)((LivingEntity)entity).field_70167_r, (double)entity.func_226278_cu_()) + vector3d1.field_72448_b;
        double d5 = MathHelper.func_219803_d((double)pPartialTicks, (double)((LivingEntity)entity).field_70166_s, (double)entity.func_226281_cx_()) + d2;
        pMatrixStack.func_227861_a_(d1, vector3d1.field_72448_b, d2);
        float f = (float)(vector3d.field_72450_a - d3);
        float f1 = (float)(vector3d.field_72448_b - d4);
        float f2 = (float)(vector3d.field_72449_c - d5);
        float f3 = 0.025f;
        IVertexBuilder ivertexbuilder = pBuffer.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = pMatrixStack.func_227866_c_().func_227870_a_();
        float f4 = MathHelper.func_226165_i_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = new BlockPos(entity.func_174824_e(pPartialTicks));
        BlockPos blockpos1 = new BlockPos(pLeashHolder.func_174824_e(pPartialTicks));
        int i = entity.func_70027_ad() ? 15 : ((LivingEntity)entity).field_70170_p.func_226658_a_(LightType.BLOCK, blockpos);
        int j = pLeashHolder.func_70027_ad() ? 15 : pLeashHolder.field_70170_p.func_226658_a_(LightType.BLOCK, blockpos1);
        int k = ((LivingEntity)entity).field_70170_p.func_226658_a_(LightType.SKY, blockpos);
        int l = ((LivingEntity)entity).field_70170_p.func_226658_a_(LightType.SKY, blockpos1);
        MobRenderer.func_229119_a_((IVertexBuilder)ivertexbuilder, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)j, (int)k, (int)l, (float)0.025f, (float)0.025f, (float)f5, (float)f6);
        MobRenderer.func_229119_a_((IVertexBuilder)ivertexbuilder, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)j, (int)k, (int)l, (float)0.025f, (float)0.0f, (float)f5, (float)f6);
        pMatrixStack.func_227865_b_();
    }

    @Inject(method={"setupRotations"}, at={@At(value="HEAD")}, cancellable=true)
    public void applyRotations(T entity, MatrixStack matrixStack, float ageInTicks, float yaw, float partialTicks, CallbackInfo callback) {
        boolean isRotationBlocked = entity.func_70651_bq().stream().anyMatch(instance -> instance.func_188419_a() instanceof ModEffect && ((ModEffect)instance.func_188419_a()).isBlockingRotations());
        if (isRotationBlocked) {
            Pose pose;
            if (!this.prevYaw.isPresent()) {
                this.prevYaw = Optional.of(Float.valueOf(yaw));
            }
            if ((pose = entity.func_213283_Z()) != Pose.SLEEPING) {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - this.prevYaw.get().floatValue()));
            }
            callback.cancel();
        } else if (this.prevYaw.isPresent()) {
            this.prevYaw = Optional.empty();
        }
    }
}

