/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.mixins.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.OutlineLayerBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;
import xyz.pixelatedw.mineminenomi.api.events.OutlineColorEvent;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityProtectionClientEvents;
import xyz.pixelatedw.mineminenomi.events.world.BiomeHandler;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypeBuffers;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mixin(value={WorldRenderer.class})
public abstract class WorldRendererMixin {
    @Shadow
    @Final
    private Minecraft field_72777_q;
    @Shadow
    private ClientWorld field_72769_h;

    @Inject(method={"initOutline"}, at={@At(value="TAIL")})
    public void initOutline(CallbackInfo ci) {
        ModRenderTypeBuffers.getInstance().initHakiAuraShader();
    }

    @Inject(method={"shouldShowEntityOutlines"}, at={@At(value="HEAD")}, cancellable=true)
    public void shouldShowEntityOutlines(CallbackInfoReturnable<Boolean> cir) {
        if (Minecraft.func_71410_x().field_71438_f.func_228448_p_() != null && ModRenderTypeBuffers.getInstance().getHakiAuraShader() != null && Minecraft.func_71410_x().field_71439_g != null) {
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"resize"}, at={@At(value="TAIL")})
    public void resize(int width, int height, CallbackInfo ci) {
        if (ModRenderTypeBuffers.getInstance() == null) {
            return;
        }
        if (ModRenderTypeBuffers.getInstance().getHakiAuraShader() != null) {
            ModRenderTypeBuffers.getInstance().getHakiAuraShader().func_148026_a(width, height);
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/OutlineLayerBuffer;endOutlineBatch()V", shift=At.Shift.BEFORE)})
    public void processShaders(MatrixStack matrixStack, float partialTicks, long finishTimeNano, boolean drawBlockOutline, ActiveRenderInfo activeRenderInfo, GameRenderer gameRenderer, LightTexture lightmap, Matrix4f projection, CallbackInfo ci) {
        ModRenderTypeBuffers.getInstance().getHakiAuraBuffer().endBatch();
        ModRenderTypeBuffers.getInstance().getHakiAuraShader().func_148018_a(partialTicks);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
    }

    @ModifyArgs(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;renderEntity(Lnet/minecraft/entity/Entity;DDDFLcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;)V"))
    private void renderEntityArgs(Args args) {
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldRenderer;renderWorldBounds(Lnet/minecraft/client/renderer/ActiveRenderInfo;)V", shift=At.Shift.AFTER)})
    private void renderBounds(MatrixStack matrixStack, float partialTicks, long finishTimeNano, boolean drawBlockOutline, ActiveRenderInfo camera, GameRenderer gameRenderer, LightTexture lightmap, Matrix4f projection, CallbackInfo ci) {
        AbilityProtectionClientEvents.renderTick(matrixStack, camera);
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")})
    public void renderEntity(Entity entity, double camX, double camY, double camZ, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, CallbackInfo callback) {
        if (buffer instanceof OutlineLayerBuffer) {
            OutlineLayerBuffer outlineBuffer = (OutlineLayerBuffer)buffer;
            OutlineColorEvent event = new OutlineColorEvent(entity);
            MinecraftForge.EVENT_BUS.post((Event)event);
            outlineBuffer.func_228472_a_(event.getColor().getRed(), event.getColor().getGreen(), event.getColor().getBlue(), event.getColor().getAlpha());
        }
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderClouds(MatrixStack matrixStack, float p_228425_2_, double p_228425_3_, double p_228425_5_, double p_228425_7_, CallbackInfo callback) {
        if (WyHelper.isInChallengeDimension((World)this.field_72769_h)) {
            callback.cancel();
            return;
        }
    }

    @ModifyVariable(method={"renderSnowAndRain"}, at=@At(value="STORE"), ordinal=1)
    private float getRainLevel(float rainLevel) {
        ResourceLocation biomeId = this.field_72769_h.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)this.field_72769_h.func_226691_t_(this.field_72777_q.field_71439_g.func_233580_cy_()));
        float newLevel = BiomeHandler.Client.getDrumSnowLevel(this.field_72777_q, rainLevel, biomeId);
        if ((double)newLevel >= 0.0) {
            return newLevel;
        }
        return rainLevel;
    }
}

