/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IEquipItemObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IObtainItemObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IReachDorikiObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenQuestTrackerScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CRequestSyncQuestDataPacket {
    private boolean openScreen;

    public CRequestSyncQuestDataPacket() {
    }

    public CRequestSyncQuestDataPacket(boolean openScreen) {
        this.openScreen = openScreen;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.openScreen);
    }

    public static CRequestSyncQuestDataPacket decode(PacketBuffer buffer) {
        CRequestSyncQuestDataPacket msg = new CRequestSyncQuestDataPacket();
        msg.openScreen = buffer.readBoolean();
        return msg;
    }

    public static void handle(CRequestSyncQuestDataPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IQuestData props = QuestDataCapability.get((PlayerEntity)player);
                for (Quest qst : props.getInProgressQuests()) {
                    if (qst == null) continue;
                    for (Objective obj : qst.getObjectives()) {
                        if (obj instanceof IReachDorikiObjective) {
                            obj.setProgress((PlayerEntity)player, EntityStatsCapability.get((LivingEntity)player).getDoriki(), false);
                        }
                        if (obj instanceof IEquipItemObjective) {
                            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                                boolean slotCheck = ((IEquipItemObjective)((Object)obj)).checkSlot(slot);
                                if (!slotCheck) continue;
                                boolean itemCheck = ((IEquipItemObjective)((Object)obj)).checkEquippedItem((PlayerEntity)player, player.func_184582_a(slot));
                                if (itemCheck) {
                                    obj.alterProgress((PlayerEntity)player, 1.0);
                                    continue;
                                }
                                obj.alterProgress((PlayerEntity)player, -1.0);
                            }
                        }
                        if (!(obj instanceof IObtainItemObjective)) continue;
                        ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
                        slots.addAll((Collection<ItemStack>)player.field_71071_by.field_70462_a);
                        slots.addAll((Collection<ItemStack>)player.field_71071_by.field_184439_c);
                        int items = ((IObtainItemObjective)((Object)obj)).checkItems(slots);
                        if (items <= 0) continue;
                        obj.setProgress((PlayerEntity)player, items, false);
                    }
                }
                WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
                if (message.openScreen) {
                    if (props.countInProgressQuests() <= 0) {
                        return;
                    }
                    WyNetwork.sendTo(new SOpenQuestTrackerScreenPacket(), (PlayerEntity)player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

