/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.crew;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.events.CrewEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class CLeaveCrewPacket {
    public void encode(PacketBuffer buffer) {
    }

    public static CLeaveCrewPacket decode(PacketBuffer buffer) {
        CLeaveCrewPacket msg = new CLeaveCrewPacket();
        return msg;
    }

    public static void handle(CLeaveCrewPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                CrewEvent.Leave event;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                UUID uuid = player.func_110124_au();
                ExtendedWorldData worldData = ExtendedWorldData.get();
                Crew crew = worldData.getCrewWithMember(uuid);
                if (crew != null && !MinecraftForge.EVENT_BUS.post((Event)(event = new CrewEvent.Leave((PlayerEntity)player, crew)))) {
                    boolean captainChange = false;
                    FactionHelper.sendMessageToCrew(player.field_70170_p, crew, (ITextComponent)new TranslationTextComponent(ModI18n.CREW_MESSAGE_LEFT, new Object[]{player.func_200200_C_().getString()}));
                    if (crew.getCaptain().getUUID().equals(uuid)) {
                        captainChange = true;
                    }
                    worldData.removeCrewMember(crew, uuid);
                    if (captainChange && crew.getCaptain() != null) {
                        FactionHelper.sendMessageToCrew(player.field_70170_p, crew, (ITextComponent)new TranslationTextComponent(ModI18n.CREW_MESSAGE_NEW_CAPTAIN, new Object[]{crew.getCaptain().getUsername()}));
                    }
                    if (crew.getMembers().size() <= 0) {
                        worldData.removeCrew(crew);
                    }
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

