/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class SChangeCombatBarPacket {
    private int combatBar;

    public SChangeCombatBarPacket() {
    }

    public SChangeCombatBarPacket(int combatBar) {
        this.combatBar = combatBar;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.combatBar);
    }

    public static SChangeCombatBarPacket decode(PacketBuffer buffer) {
        SChangeCombatBarPacket msg = new SChangeCombatBarPacket();
        msg.combatBar = buffer.readInt();
        return msg;
    }

    public static void handle(SChangeCombatBarPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SChangeCombatBarPacket message) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
            abilityProps.setCombatBarSet(message.combatBar);
        }
    }
}

