/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class SEquipAbilityPacket {
    private int entityId;
    private int slot;
    private ResourceLocation abilityId;

    public SEquipAbilityPacket() {
    }

    public SEquipAbilityPacket(int entityId, int slot, AbilityCore core) {
        this.entityId = entityId;
        this.slot = slot;
        this.abilityId = core.getRegistryName();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.slot);
        buffer.func_192572_a(this.abilityId);
    }

    public static SEquipAbilityPacket decode(PacketBuffer buffer) {
        SEquipAbilityPacket msg = new SEquipAbilityPacket();
        msg.entityId = buffer.readInt();
        msg.slot = buffer.readInt();
        msg.abilityId = buffer.func_192575_l();
        return msg;
    }

    public static void handle(SEquipAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SEquipAbilityPacket message) {
            try {
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                Entity target = world.func_73045_a(message.entityId);
                if (target == null || !(target instanceof LivingEntity)) {
                    return;
                }
                IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)target);
                AbilityCore core = (AbilityCore)ModRegistries.ABILITIES.getValue(message.abilityId);
                Object ability = core.createAbility();
                abilityDataProps.setEquippedAbility(message.slot, (IAbility)ability);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

