/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import com.google.common.base.Strings;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IExtraUpdateData;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SUpdateExtraDataPacket {
    private int entityId;
    private String abilityId;
    private CompoundNBT extraData;
    private boolean isEquipped;

    @Deprecated
    public SUpdateExtraDataPacket() {
    }

    @Deprecated
    public SUpdateExtraDataPacket(PlayerEntity player, Ability ability) {
        this.entityId = player.func_145782_y();
        this.abilityId = WyHelper.getResourceName(ability.getName());
        this.isEquipped = true;
        if (ability instanceof PassiveAbility) {
            this.isEquipped = false;
        }
        if (ability instanceof IExtraUpdateData) {
            this.extraData = ((IExtraUpdateData)((Object)ability)).getExtraData();
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.isEquipped);
        buffer.writeInt(this.entityId);
        int len = this.abilityId.length();
        buffer.writeInt(len);
        buffer.func_211400_a(this.abilityId, len);
        buffer.writeBoolean(this.extraData != null);
        if (this.extraData != null) {
            buffer.func_150786_a(this.extraData);
        }
    }

    public static SUpdateExtraDataPacket decode(PacketBuffer buffer) {
        SUpdateExtraDataPacket msg = new SUpdateExtraDataPacket();
        msg.isEquipped = buffer.readBoolean();
        msg.entityId = buffer.readInt();
        int len = buffer.readInt();
        msg.abilityId = buffer.func_150789_c(len);
        boolean hasExtraData = buffer.readBoolean();
        if (hasExtraData) {
            msg.extraData = buffer.func_150793_b();
        }
        return msg;
    }

    public static void handle(SUpdateExtraDataPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateExtraDataPacket message) {
            if (Strings.isNullOrEmpty((String)message.abilityId)) {
                return;
            }
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof PlayerEntity)) {
                return;
            }
            ResourceLocation res = new ResourceLocation("mineminenomi", message.abilityId);
            AbilityCore<?> templateAbl = AbilityCore.get(res);
            if (templateAbl == null) {
                return;
            }
            IAbilityData props = AbilityDataCapability.get((LivingEntity)target);
            Object ability = null;
            boolean isEquipped = message.isEquipped;
            ability = isEquipped ? props.getEquippedAbility(templateAbl) : props.getEquippedOrPassiveAbility(templateAbl);
            if (ability == null) {
                return;
            }
            if (message.extraData != null && ability instanceof IExtraUpdateData) {
                ((IExtraUpdateData)ability).setExtraData(message.extraData);
            }
        }
    }
}

