/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityProtectionClientEvents;

public class SViewProtectionPacket {
    private boolean state;
    private Map<String, ProtectedArea> areas = new HashMap<String, ProtectedArea>();

    public SViewProtectionPacket() {
    }

    public SViewProtectionPacket(boolean state, Map<String, ProtectedArea> areas) {
        this.state = state;
        this.areas = areas;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.state);
        buffer.writeInt(this.areas.size());
        for (ProtectedArea area : this.areas.values()) {
            buffer.func_179255_a(area.getCenter());
            buffer.writeInt(area.getSize());
            buffer.func_180714_a(area.getLabel());
        }
    }

    public static SViewProtectionPacket decode(PacketBuffer buffer) {
        SViewProtectionPacket msg = new SViewProtectionPacket();
        msg.state = buffer.readBoolean();
        int areas = buffer.readInt();
        msg.areas.clear();
        for (int i = 0; i < areas; ++i) {
            BlockPos pos = buffer.func_179259_c();
            int size = buffer.readInt();
            String label = buffer.func_218666_n();
            ProtectedArea area = new ProtectedArea(pos, size, label);
            msg.areas.put(label, area);
        }
        return msg;
    }

    public static void handle(SViewProtectionPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SViewProtectionPacket message) {
            AbilityProtectionClientEvents.CLIENT_AREAS.clear();
            if (message.state) {
                AbilityProtectionClientEvents.CLIENT_AREAS.putAll(message.areas);
            }
        }
    }
}

