/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability.components;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class SChangeAbilityAltModePacket<E extends Enum<E>> {
    private int entityId;
    private int abilityId;
    private int mode;

    public SChangeAbilityAltModePacket() {
    }

    public SChangeAbilityAltModePacket(LivingEntity entity, IAbility ability, E mode) {
        this.entityId = entity.func_145782_y();
        this.abilityId = AbilityDataCapability.get(entity).getEquippedAbilitySlot(ability);
        this.mode = ((Enum)mode).ordinal();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.abilityId);
        buffer.writeInt(this.mode);
    }

    public static SChangeAbilityAltModePacket decode(PacketBuffer buffer) {
        SChangeAbilityAltModePacket msg = new SChangeAbilityAltModePacket();
        msg.entityId = buffer.readInt();
        msg.abilityId = buffer.readInt();
        msg.mode = buffer.readInt();
        return msg;
    }

    public static void handle(SChangeAbilityAltModePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static <E extends Enum<E>> void handle(SChangeAbilityAltModePacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)target;
            IAbilityData props = AbilityDataCapability.get(entity);
            Object abl = props.getEquippedAbility(message.abilityId);
            if (abl == null) {
                return;
            }
            abl.getComponent(ModAbilityKeys.ALT_MODE).ifPresent(c -> {
                Enum[] modes = (Enum[])c.getAltMode().getEnumConstants();
                c.setMode(entity, modes[message.mode]);
            });
        }
    }
}

