/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability.components;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class SSetPauseTickPacket {
    private int entityId;
    private ResourceLocation abilityKey;
    private boolean pauseFlag;

    public SSetPauseTickPacket() {
    }

    public SSetPauseTickPacket(LivingEntity entity, AbilityCore core, boolean pauseFlag) {
        this.entityId = entity.func_145782_y();
        this.abilityKey = core.getRegistryName();
        this.pauseFlag = pauseFlag;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_192572_a(this.abilityKey);
        buffer.writeBoolean(this.pauseFlag);
    }

    public static SSetPauseTickPacket decode(PacketBuffer buffer) {
        SSetPauseTickPacket msg = new SSetPauseTickPacket();
        msg.entityId = buffer.readInt();
        msg.abilityKey = buffer.func_192575_l();
        msg.pauseFlag = buffer.readBoolean();
        return msg;
    }

    public static void handle(SSetPauseTickPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSetPauseTickPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            AbilityCore core = (AbilityCore)ModRegistries.ABILITIES.getValue(message.abilityKey);
            if (core == null || core.getType() != AbilityType.PASSIVE) {
                return;
            }
            LivingEntity entity = (LivingEntity)target;
            IAbilityData props = AbilityDataCapability.get(entity);
            Object ability = props.getPassiveAbility(core);
            if (ability == null) {
                return;
            }
            ability.getComponent(ModAbilityKeys.PAUSE_TICK).ifPresent(c -> c.setPause(entity, message.pauseFlag));
        }
    }
}

