/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability.components;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class SSwingTriggerPacket<E extends Enum<E>> {
    private int entityId;
    private int abilityId;

    public SSwingTriggerPacket() {
    }

    public SSwingTriggerPacket(LivingEntity entity, IAbility ability) {
        this.entityId = entity.func_145782_y();
        this.abilityId = AbilityDataCapability.get(entity).getEquippedAbilitySlot(ability);
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.abilityId);
    }

    public static SSwingTriggerPacket decode(PacketBuffer buffer) {
        SSwingTriggerPacket msg = new SSwingTriggerPacket();
        msg.entityId = buffer.readInt();
        msg.abilityId = buffer.readInt();
        return msg;
    }

    public static void handle(SSwingTriggerPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static <E extends Enum<E>> void handle(SSwingTriggerPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)target;
            IAbilityData props = AbilityDataCapability.get(entity);
            Object abl = props.getEquippedAbility(message.abilityId);
            if (abl == null) {
                return;
            }
            abl.getComponent(ModAbilityKeys.SWING_TRIGGER).ifPresent(c -> c.swing(entity));
        }
    }
}

