/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.animations;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.animations.IAnimation;
import xyz.pixelatedw.mineminenomi.api.animations.TimeAnimation;
import xyz.pixelatedw.mineminenomi.api.entities.IAnimatedEntity;

public class SSetNPCTimeAnimationPacket {
    private int entityId;
    private int animation;
    private int state;

    public SSetNPCTimeAnimationPacket() {
    }

    public SSetNPCTimeAnimationPacket(int entityId, int animationId, TimeAnimation.State state) {
        this.entityId = entityId;
        this.animation = animationId;
        this.state = state.ordinal();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.animation);
        buffer.writeInt(this.state);
    }

    public static SSetNPCTimeAnimationPacket decode(PacketBuffer buffer) {
        SSetNPCTimeAnimationPacket msg = new SSetNPCTimeAnimationPacket();
        msg.entityId = buffer.readInt();
        msg.animation = buffer.readInt();
        msg.state = buffer.readInt();
        return msg;
    }

    public static void handle(SSetNPCTimeAnimationPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSetNPCTimeAnimationPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity) || !(target instanceof IAnimatedEntity)) {
                return;
            }
            LivingEntity target2 = (LivingEntity)target;
            int animId = message.animation - 1;
            if (animId < 0) {
                return;
            }
            IAnimation anim = ((IAnimatedEntity)target2).getAnimations()[animId];
            if (!(anim instanceof TimeAnimation)) {
                return;
            }
            TimeAnimation.State state = TimeAnimation.State.values()[message.state];
            switch (state) {
                case PLAY: {
                    ((TimeAnimation)anim).start(target2);
                    break;
                }
                case STOP: {
                    ((TimeAnimation)anim).stop(target2);
                    break;
                }
            }
        }
    }
}

