/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.entities;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;

public class SUpdateLightningEntity {
    private int entityId;
    private float length;
    private float size;
    private int branches;
    private int segments;
    private int color;
    private int alpha;
    private int angle;
    private boolean mimicVanilla;
    private boolean lightningMovement;
    private boolean energyEffect;

    public SUpdateLightningEntity() {
    }

    public SUpdateLightningEntity(LightningEntity entity) {
        this.entityId = entity.func_145782_y();
        this.length = entity.getLength();
        this.size = entity.getSize();
        this.branches = entity.getBranches();
        this.segments = entity.getSegments();
        this.color = entity.getColor();
        this.alpha = entity.getAlpha();
        this.angle = entity.getAngle();
        this.mimicVanilla = entity.getMimicVanilla();
        this.lightningMovement = entity.getLightningMovement();
        this.energyEffect = entity.getEnergyEffect();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeFloat(this.length);
        buffer.writeFloat(this.size);
        buffer.writeInt(this.branches);
        buffer.writeInt(this.segments);
        buffer.writeInt(this.color);
        buffer.writeInt(this.alpha);
        buffer.writeInt(this.angle);
        buffer.writeBoolean(this.mimicVanilla);
        buffer.writeBoolean(this.lightningMovement);
        buffer.writeBoolean(this.energyEffect);
    }

    public static SUpdateLightningEntity decode(PacketBuffer buffer) {
        SUpdateLightningEntity msg = new SUpdateLightningEntity();
        msg.entityId = buffer.readInt();
        msg.length = buffer.readFloat();
        msg.size = buffer.readFloat();
        msg.branches = buffer.readInt();
        msg.segments = buffer.readInt();
        msg.color = buffer.readInt();
        msg.alpha = buffer.readInt();
        msg.angle = buffer.readInt();
        msg.mimicVanilla = buffer.readBoolean();
        msg.lightningMovement = buffer.readBoolean();
        msg.energyEffect = buffer.readBoolean();
        return msg;
    }

    public static void handle(SUpdateLightningEntity message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateLightningEntity message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LightningEntity)) {
                return;
            }
            LightningEntity proj = (LightningEntity)target;
            proj.setLightningProperties(message.length, message.size, message.branches, message.segments, message.color, message.alpha, message.angle, message.mimicVanilla, message.lightningMovement, message.energyEffect);
        }
    }
}

