/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.entities;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;

public class SUpdateProjBlockCollisionBox {
    private int entityId;
    private double sizeX;
    private double sizeY;
    private double sizeZ;

    public SUpdateProjBlockCollisionBox() {
    }

    public SUpdateProjBlockCollisionBox(int entityId, double sizeX, double sizeY, double sizeZ) {
        this.entityId = entityId;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeDouble(this.sizeX);
        buffer.writeDouble(this.sizeY);
        buffer.writeDouble(this.sizeZ);
    }

    public static SUpdateProjBlockCollisionBox decode(PacketBuffer buffer) {
        SUpdateProjBlockCollisionBox msg = new SUpdateProjBlockCollisionBox();
        msg.entityId = buffer.readInt();
        msg.sizeX = buffer.readDouble();
        msg.sizeY = buffer.readDouble();
        msg.sizeZ = buffer.readDouble();
        return msg;
    }

    public static void handle(SUpdateProjBlockCollisionBox message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SUpdateProjBlockCollisionBox message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof AbilityProjectileEntity)) {
                return;
            }
            AbilityProjectileEntity proj = (AbilityProjectileEntity)target;
            proj.setBlockCollisionSize(message.sizeX, message.sizeY, message.sizeZ);
        }
    }
}

