/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeInvitation;
import xyz.pixelatedw.mineminenomi.screens.ChallengesScreen;

public class SOpenChallengesScreenPacket {
    private List<Challenge> challenges;
    private List<ChallengeInvitation> invites;

    public SOpenChallengesScreenPacket() {
    }

    public SOpenChallengesScreenPacket(List<Challenge> challenges, List<ChallengeInvitation> invites) {
        this.challenges = challenges;
        this.invites = invites;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.challenges.size());
        for (Challenge ch : this.challenges) {
            buffer.func_192572_a(ch.getCore().getRegistryName());
            buffer.func_150786_a(ch.save(new CompoundNBT()));
        }
        buffer.writeInt(this.invites.size());
        for (ChallengeInvitation invite : this.invites) {
            buffer.func_179252_a(invite.getSenderId());
            buffer.func_192572_a(invite.getChallenge().getRegistryName());
            buffer.writeLong(invite.getSendTime());
            buffer.writeInt(invite.getGroupSlot());
        }
    }

    public static SOpenChallengesScreenPacket decode(PacketBuffer buffer) {
        Object challenge;
        int i;
        SOpenChallengesScreenPacket msg = new SOpenChallengesScreenPacket();
        msg.challenges = new ArrayList<Challenge>();
        int size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            ChallengeCore core = (ChallengeCore)ModRegistries.CHALLENGES.getValue(buffer.func_192575_l());
            if (core == null) continue;
            challenge = core.createChallenge();
            ((Challenge)challenge).load(buffer.func_150793_b());
            msg.challenges.add((Challenge)challenge);
        }
        msg.invites = new ArrayList<ChallengeInvitation>();
        size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            UUID uuid = buffer.func_179253_g();
            challenge = (ChallengeCore)ModRegistries.CHALLENGES.getValue(buffer.func_192575_l());
            long gameTime = buffer.readLong();
            int groupSlot = buffer.readInt();
            ChallengeInvitation invite = new ChallengeInvitation(uuid, (ChallengeCore<?>)((Object)challenge), gameTime, groupSlot);
            msg.invites.add(invite);
        }
        return msg;
    }

    public static void handle(SOpenChallengesScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SOpenChallengesScreenPacket message) {
            ChallengesScreen.open(message.challenges, message.invites);
        }
    }
}

