/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.screens.CrewDetailsScreen;

public class SOpenCrewScreenPacket {
    private Crew crew;

    public SOpenCrewScreenPacket() {
    }

    public SOpenCrewScreenPacket(Crew crew) {
        this.crew = crew;
    }

    public void encode(PacketBuffer buffer) {
        CompoundNBT crewData = this.crew.write();
        buffer.func_150786_a(crewData);
    }

    public static SOpenCrewScreenPacket decode(PacketBuffer buffer) {
        SOpenCrewScreenPacket msg = new SOpenCrewScreenPacket();
        CompoundNBT crewData = buffer.func_150793_b();
        msg.crew = Crew.from(crewData);
        return msg;
    }

    public static void handle(SOpenCrewScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SOpenCrewScreenPacket message) {
            CrewDetailsScreen.open(message.crew);
        }
    }
}

