/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects;

import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CommonExplosionParticleEffect
extends ParticleEffect {
    private int explosionSize;

    public CommonExplosionParticleEffect() {
        this(2);
    }

    public CommonExplosionParticleEffect(int explosionSize) {
        this.explosionSize = explosionSize;
    }

    @Override
    public void spawn(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < this.explosionSize * 2; ++i) {
            double x = posX + WyHelper.randomWithRange(-this.explosionSize / 2, this.explosionSize / 2) + WyHelper.randomDouble();
            double y = posY + WyHelper.randomDouble();
            double z = posZ + WyHelper.randomWithRange(-this.explosionSize / 2, this.explosionSize / 2) + WyHelper.randomDouble();
            motionX = WyHelper.randomWithRange(-2, 2) + WyHelper.randomDouble();
            motionY = WyHelper.randomWithRange(-2, 2) + WyHelper.randomDouble();
            motionZ = WyHelper.randomWithRange(-2, 2) + WyHelper.randomDouble();
            double middlePoint = 0.5 / ((double)(5 / this.explosionSize) + 0.1);
            motionX *= (middlePoint *= WyHelper.randomDouble() * 2.0 + (double)0.3f) / 2.0;
            motionY *= middlePoint / 2.0;
            motionZ *= middlePoint / 2.0;
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197627_t, (ServerWorld)world, x, y + 1.0, z);
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197598_I, (ServerWorld)world, posX, posY + 1.0, posZ);
        }
    }
}

